/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import org.json.JSONException;
import quality.gates.jenkins.plugin.GlobalConfig;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.QGException;
import quality.gates.sonar.api.QualityGatesProvider;

public class BuildDecision {
    private QualityGatesProvider qualityGatesProvider;

    public BuildDecision() {
        this.qualityGatesProvider = new QualityGatesProvider();
    }

    public BuildDecision(QualityGatesProvider qualityGatesProvider) {
        this.qualityGatesProvider = qualityGatesProvider;
    }

    public boolean getStatus(GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance, JobConfigData jobConfigData) throws QGException {
        try {
            return this.qualityGatesProvider.getAPIResultsForQualityGates(jobConfigData, globalConfigDataForSonarInstance).hasStatusGreen();
        }
        catch (JSONException e) {
            throw new QGException("Please check your credentials or your Project Key", e);
        }
    }

    public GlobalConfigDataForSonarInstance chooseSonarInstance(GlobalConfig globalConfig, JobConfigData jobConfigData) {
        GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance = globalConfig.fetchListOfGlobalConfigData().isEmpty() ? this.noSonarInstance(jobConfigData) : (globalConfig.fetchListOfGlobalConfigData().size() == 1 ? this.singleSonarInstance(globalConfig, jobConfigData) : this.multipleSonarInstances(jobConfigData.getSonarInstanceName(), globalConfig));
        return globalConfigDataForSonarInstance;
    }

    public GlobalConfigDataForSonarInstance noSonarInstance(JobConfigData jobConfigData) {
        jobConfigData.setSonarInstanceName("");
        return new GlobalConfigDataForSonarInstance();
    }

    public GlobalConfigDataForSonarInstance singleSonarInstance(GlobalConfig globalConfig, JobConfigData jobConfigData) {
        GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance = globalConfig.fetchListOfGlobalConfigData().get(0);
        jobConfigData.setSonarInstanceName(globalConfigDataForSonarInstance.getName());
        return globalConfigDataForSonarInstance;
    }

    public GlobalConfigDataForSonarInstance multipleSonarInstances(String instanceName, GlobalConfig globalConfig) {
        GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance = globalConfig.getSonarInstanceByName(instanceName);
        if (globalConfigDataForSonarInstance != null) {
            return globalConfigDataForSonarInstance;
        }
        return null;
    }
}

