/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.qmetry.CreateZip;
import com.qmetry.FindFile;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@IgnoreJRERequirement
public class UploadToServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> uploadToTheServer(String apikeyserver, String jiraurlserver, String password, String testrunnameserver, String labelsserver, String sprintserver, String versionserver, String componentserver, String username, String fileserver, boolean attachFileServer, String selectionserver, String platformserver, String commentserver, String testrunkeyserver, String testassethierarchyserver, String testCaseUpdateLevelServer, String jirafieldsserver, int buildnumber, Run<?, ?> run, TaskListener listener, FilePath workspace) throws InvalidCredentialsException, AuthenticationException, ProtocolException, IOException, ParseException, InterruptedException, FileNotFoundException {
        File resultFile = FindFile.findFile(fileserver, run, listener, selectionserver, workspace);
        if (resultFile == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String toEncode = username.trim() + ":" + password.trim();
        byte[] mes = toEncode.getBytes("UTF-8");
        String encodedString = DatatypeConverter.printBase64Binary((byte[])mes);
        String basicAuth = "Basic " + encodedString;
        if (testrunnameserver != null && !testrunnameserver.isEmpty()) {
            testrunnameserver = testrunnameserver.trim() + " #" + buildnumber;
        }
        String filepathserver = "";
        boolean iszip = false;
        if (resultFile.isDirectory()) {
            iszip = true;
            listener.getLogger().println("QMetry for JIRA : Given Path is Directory.");
            listener.getLogger().println("QMetry for JIRA : Creating Zip...");
            filepathserver = CreateZip.createZip(resultFile.getAbsolutePath(), selectionserver, attachFileServer);
            listener.getLogger().println("QMetry for JIRA : Zip file path : " + filepathserver);
        } else {
            filepathserver = resultFile.getAbsolutePath();
            String fileExtension = "";
            if (filepathserver.contains(".") && filepathserver.lastIndexOf(".") != 0) {
                fileExtension = filepathserver.substring(filepathserver.lastIndexOf(".") + 1);
            }
            if (fileExtension.equals("zip")) {
                iszip = true;
            }
        }
        HttpPost uploadFile = new HttpPost(jiraurlserver.trim() + "/rest/qtm/latest/automation/importresults");
        uploadFile.addHeader("Authorization", basicAuth);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("apiKey", apikeyserver.trim(), ContentType.TEXT_PLAIN);
        builder.addTextBody("format", selectionserver.trim(), ContentType.TEXT_PLAIN);
        if (attachFileServer) {
            builder.addTextBody("attachFile", String.valueOf(attachFileServer));
        }
        if (testrunnameserver != null && !testrunnameserver.isEmpty()) {
            builder.addTextBody("testRunName", testrunnameserver, ContentType.TEXT_PLAIN);
        }
        if (platformserver != null && !platformserver.isEmpty()) {
            builder.addTextBody("platform", platformserver.trim(), ContentType.TEXT_PLAIN);
        }
        if (labelsserver != null && !labelsserver.isEmpty()) {
            builder.addTextBody("labels", labelsserver.trim(), ContentType.TEXT_PLAIN);
        }
        if (versionserver != null && !versionserver.isEmpty()) {
            builder.addTextBody("versions", versionserver.trim(), ContentType.TEXT_PLAIN);
        }
        if (componentserver != null && !componentserver.isEmpty()) {
            builder.addTextBody("components", componentserver.trim(), ContentType.TEXT_PLAIN);
        }
        if (sprintserver != null && !sprintserver.isEmpty()) {
            builder.addTextBody("sprint", sprintserver.trim(), ContentType.TEXT_PLAIN);
        }
        if (commentserver != null && !commentserver.isEmpty()) {
            builder.addTextBody("comment", commentserver.trim(), ContentType.TEXT_PLAIN);
        }
        if (testrunkeyserver != null && !testrunkeyserver.isEmpty()) {
            builder.addTextBody("testRunKey", testrunkeyserver.trim());
        }
        if (testassethierarchyserver != null && !testassethierarchyserver.isEmpty()) {
            builder.addTextBody("testAssetHierarchy", testassethierarchyserver.trim());
            if (testassethierarchyserver.equals("TestCase-TestStep") && testCaseUpdateLevelServer != null && !testCaseUpdateLevelServer.isEmpty()) {
                builder.addTextBody("testCaseUpdateLevel", testCaseUpdateLevelServer);
            }
        }
        if (jirafieldsserver != null && !jirafieldsserver.isEmpty()) {
            JSONParser parser = new JSONParser();
            JSONArray array = (JSONArray)parser.parse(jirafieldsserver.trim());
            builder.addTextBody("JIRAFields", array.toString());
        }
        builder.addTextBody("isZip", String.valueOf(iszip));
        File f = new File(filepathserver);
        builder.addPart("file", (ContentBody)new FileBody(f));
        HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)uploadFile);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream content = entity.getContent();
                StringBuilder builder1 = new StringBuilder();
                InputStreamReader read = new InputStreamReader(content, StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(read);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        builder1.append(line);
                    }
                }
                finally {
                    reader.close();
                    content.close();
                }
                JSONParser parser = new JSONParser();
                JSONObject responsejson = (JSONObject)parser.parse(builder1.toString());
                Boolean success = (Boolean)responsejson.get((Object)"success");
                if (success.booleanValue()) {
                    map.put("success", "true");
                    JSONObject result = (JSONObject)responsejson.get((Object)"result");
                    if (result != null) {
                        map.put("iszip", "false");
                        String trk = (String)result.get((Object)"testRunKey");
                        String tru = (String)result.get((Object)"testRunUrl");
                        String message = (String)result.get((Object)"message");
                        map.put("testRunKey", trk);
                        map.put("testRunUrl", tru);
                        map.put("message", message);
                        map.put("response", builder1.toString());
                    }
                } else {
                    map.put("success", "false");
                    String errorMessage = (String)responsejson.get((Object)"errorMessage");
                    map.put("errorMessage", errorMessage);
                }
            }
        } else {
            map.put("success", "error");
            map.put("responseCode", String.valueOf(statusLine.getStatusCode()));
        }
        return map;
    }
}

