/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.descriptor;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import jenkins.plugins.publish_over.BPTransfer;
import jenkins.plugins.publish_over_ssh.BapSshHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import jenkins.plugins.publish_over_ssh.BapSshTransfer;
import jenkins.plugins.publish_over_ssh.Messages;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class BapSshTransferDescriptor
extends Descriptor<BapSshTransfer> {
    public BapSshTransferDescriptor() {
        super(BapSshTransfer.class);
    }

    public String getDisplayName() {
        return Messages.transfer_descriptor_displayName();
    }

    public boolean canUseExcludes() {
        return BPTransfer.canUseExcludes();
    }

    public FormValidation doCheckExecTimeout(@QueryParameter String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doCheckSourceFiles(@QueryParameter String configName, @QueryParameter String sourceFiles, @QueryParameter String execCommand) {
        if (Util.fixEmptyAndTrim((String)configName) != null) {
            BapSshPublisherPlugin.Descriptor pluginDescriptor = (BapSshPublisherPlugin.Descriptor)Hudson.getInstance().getDescriptorByType(BapSshPublisherPlugin.Descriptor.class);
            BapSshHostConfiguration hostConfig = pluginDescriptor.getConfiguration(configName);
            if (hostConfig == null) {
                return FormValidation.error((String)Messages.descriptor_sourceFiles_check_configNotFound(configName));
            }
            if (hostConfig.isEffectiveDisableExec()) {
                return FormValidation.validateRequired((String)sourceFiles);
            }
        }
        return this.checkTransferSet(sourceFiles, execCommand);
    }

    public FormValidation doCheckExecCommand(@QueryParameter String sourceFiles, @QueryParameter String execCommand) {
        return this.checkTransferSet(sourceFiles, execCommand);
    }

    private FormValidation checkTransferSet(String sourceFiles, String execCommand) {
        return this.haveAtLeastOne(sourceFiles, execCommand) ? FormValidation.ok() : FormValidation.error((String)Messages.descriptor_sourceOrExec());
    }

    private boolean haveAtLeastOne(String ... values) {
        for (String value : values) {
            if (Util.fixEmptyAndTrim((String)value) == null) continue;
            return true;
        }
        return false;
    }

    public jenkins.plugins.publish_over.view_defaults.BPTransfer.Messages getCommonFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.BPTransfer.Messages();
    }
}

