/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Hudson;
import java.io.IOException;
import java.util.Properties;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_ssh.BapSshClient;
import jenkins.plugins.publish_over_ssh.BapSshCommonConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshCredentials;
import jenkins.plugins.publish_over_ssh.BapSshKeyInfo;
import jenkins.plugins.publish_over_ssh.BapSshPublisher;
import jenkins.plugins.publish_over_ssh.BapSshSftpSetupException;
import jenkins.plugins.publish_over_ssh.BapSshUtil;
import jenkins.plugins.publish_over_ssh.Messages;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshHostConfigurationDescriptor;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshHostConfiguration
extends BPHostConfiguration<BapSshClient, BapSshCommonConfiguration>
implements Describable<BapSshHostConfiguration> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 22;
    public static final int DEFAULT_TIMEOUT = 300000;
    private static final Log LOG = LogFactory.getLog(BapSshHostConfiguration.class);
    private int timeout;
    private boolean overrideKey;
    private boolean disableExec;
    private final BapSshKeyInfo keyInfo;

    @DataBoundConstructor
    public BapSshHostConfiguration(String name, String hostname, String username, String encryptedPassword, String remoteRootDir, int port, int timeout, boolean overrideKey, String keyPath, String key, boolean disableExec) {
        super(name, hostname, username, null, remoteRootDir, port);
        this.timeout = timeout;
        this.overrideKey = overrideKey;
        this.keyInfo = new BapSshKeyInfo(encryptedPassword, key, keyPath);
        this.disableExec = disableExec;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected final String getPassword() {
        return this.keyInfo.getPassphrase();
    }

    public final void setPassword(String password) {
        this.keyInfo.setPassphrase(password);
    }

    public final String getEncryptedPassword() {
        return this.keyInfo.getEncryptedPassphrase();
    }

    public String getKeyPath() {
        return this.keyInfo.getKeyPath();
    }

    public void setKeyPath(String keyPath) {
        this.keyInfo.setKeyPath(keyPath);
    }

    public String getKey() {
        return this.keyInfo.getKey();
    }

    public void setKey(String key) {
        this.keyInfo.setKey(key);
    }

    public boolean isOverrideKey() {
        return this.overrideKey;
    }

    public void setOverrideKey(boolean overrideKey) {
        this.overrideKey = overrideKey;
    }

    public boolean isDisableExec() {
        return this.disableExec;
    }

    public void setDisableExec(boolean disableExec) {
        this.disableExec = disableExec;
    }

    public boolean isEffectiveDisableExec() {
        return ((BapSshCommonConfiguration)this.getCommonConfig()).isDisableAllExec() || this.disableExec;
    }

    private BapSshKeyInfo getEffectiveKeyInfo(BPBuildInfo buildInfo) {
        BapSshCredentials publisherCredentials = BapSshHostConfiguration.getPublisherOverrideCredentials(buildInfo);
        if (publisherCredentials != null) {
            return publisherCredentials;
        }
        return this.overrideKey ? this.keyInfo : (BapSshKeyInfo)this.getCommonConfig();
    }

    public BapSshClient createClient(BPBuildInfo buildInfo, BapPublisher publisher) {
        return this.createClient(buildInfo, ((BapSshPublisher)publisher).isSftpRequired());
    }

    public BapSshClient createClient(BPBuildInfo buildInfo) {
        return this.createClient(buildInfo, true);
    }

    public BapSshClient createClient(BPBuildInfo buildInfo, boolean connectSftp) {
        JSch ssh = this.createJSch();
        Session session = this.createSession(buildInfo, ssh);
        BapSshClient bapClient = new BapSshClient(buildInfo, session, this.isEffectiveDisableExec());
        try {
            BapSshKeyInfo keyInfo = this.getEffectiveKeyInfo(buildInfo);
            Properties sessionProperties = this.getSessionProperties();
            if (keyInfo.useKey()) {
                this.setKey(buildInfo, ssh, keyInfo);
                sessionProperties.put("PreferredAuthentications", "publickey");
            } else {
                session.setPassword(Util.fixNull((String)keyInfo.getPassphrase()));
            }
            session.setConfig(sessionProperties);
            this.connect(buildInfo, session);
            if (connectSftp) {
                this.setupSftp(buildInfo, bapClient);
            }
            return bapClient;
        }
        catch (IOException ioe) {
            bapClient.disconnectQuietly();
            throw new BapPublisherException(Messages.exception_failedToCreateClient(ioe.getLocalizedMessage()), (Throwable)ioe);
        }
        catch (RuntimeException re) {
            bapClient.disconnectQuietly();
            throw re;
        }
    }

    private void setupSftp(BPBuildInfo buildInfo, BapSshClient bapClient) throws IOException {
        ChannelSftp sftp = this.openSftpChannel(buildInfo, bapClient.getSession());
        bapClient.setSftp(sftp);
        this.connectSftpChannel(buildInfo, sftp);
        this.changeToRootDirectory((BPClient)bapClient);
        this.setRootDirectoryInClient(bapClient, sftp);
    }

    private void setKey(BPBuildInfo buildInfo, JSch ssh, BapSshKeyInfo keyInfo) {
        try {
            ssh.addIdentity("TheKey", keyInfo.getEffectiveKey(buildInfo), null, BapSshUtil.toBytes(keyInfo.getPassphrase()));
        }
        catch (JSchException jsche) {
            throw new BapPublisherException(Messages.exception_addIdentity(jsche.getLocalizedMessage()), (Throwable)jsche);
        }
    }

    private void setRootDirectoryInClient(BapSshClient client, ChannelSftp sftp) throws IOException {
        if (this.isDirectoryAbsolute(this.getRemoteRootDir())) {
            client.setAbsoluteRemoteRoot(this.getRemoteRootDir());
        } else {
            client.setAbsoluteRemoteRoot(this.getRootDirectoryFromPwd(client, sftp));
        }
    }

    private String getRootDirectoryFromPwd(BapSshClient client, ChannelSftp sftp) {
        BPBuildInfo buildInfo = client.getBuildInfo();
        buildInfo.printIfVerbose(Messages.console_usingPwd());
        try {
            String pwd = sftp.pwd();
            if (!this.isDirectoryAbsolute(pwd)) {
                throw new BapPublisherException(Messages.exception_pwdNotAbsolute(pwd));
            }
            return pwd;
        }
        catch (SftpException sftpe) {
            String message = Messages.exception_pwd(sftpe.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)sftpe);
            throw new BapPublisherException(message);
        }
    }

    private void connectSftpChannel(BPBuildInfo buildInfo, ChannelSftp channel) {
        buildInfo.printIfVerbose(Messages.console_sftp_connecting());
        try {
            channel.connect(this.getTimeout());
        }
        catch (JSchException jse) {
            String message = Messages.exception_sftp_connect(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapSshSftpSetupException(message);
        }
        buildInfo.printIfVerbose(Messages.console_sftp_connected());
    }

    private ChannelSftp openSftpChannel(BPBuildInfo buildInfo, Session session) {
        ChannelSftp sftp;
        buildInfo.printIfVerbose(Messages.console_sftp_opening());
        try {
            sftp = (ChannelSftp)session.openChannel("sftp");
        }
        catch (JSchException jse) {
            String message = Messages.exception_sftp_open(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapSshSftpSetupException(message);
        }
        buildInfo.printIfVerbose(Messages.console_sftp_opened());
        return sftp;
    }

    private Properties getSessionProperties() {
        Properties props = new Properties();
        props.put("StrictHostKeyChecking", "no");
        return props;
    }

    private void connect(BPBuildInfo buildInfo, Session session) {
        buildInfo.printIfVerbose(Messages.console_session_connecting());
        try {
            session.connect(this.getTimeout());
        }
        catch (JSchException jse) {
            String message = Messages.exception_session_connect(this.getName(), jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapPublisherException(message);
        }
        buildInfo.printIfVerbose(Messages.console_session_connected());
    }

    private Session createSession(BPBuildInfo buildInfo, JSch ssh) {
        BapSshCredentials overrideCreds = BapSshHostConfiguration.getPublisherOverrideCredentials(buildInfo);
        String username = overrideCreds == null ? this.getUsername() : overrideCreds.getUsername();
        try {
            buildInfo.printIfVerbose(Messages.console_session_creating(username, this.getHostnameTrimmed(), this.getPort()));
            return ssh.getSession(username, this.getHostnameTrimmed(), this.getPort());
        }
        catch (JSchException jse) {
            throw new BapPublisherException(Messages.exception_session_create(username, this.getHostnameTrimmed(), this.getPort(), jse.getLocalizedMessage()), (Throwable)jse);
        }
    }

    private static BapSshCredentials getPublisherOverrideCredentials(BPBuildInfo buildInfo) {
        return (BapSshCredentials)buildInfo.get("credentials");
    }

    protected JSch createJSch() {
        return new JSch();
    }

    public BapSshHostConfigurationDescriptor getDescriptor() {
        return (BapSshHostConfigurationDescriptor)Hudson.getInstance().getDescriptorByType(BapSshHostConfigurationDescriptor.class);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BapSshHostConfiguration that) {
        return super.addToEquals(builder, (BPHostConfiguration)that).append((Object)this.keyInfo, (Object)that.keyInfo).append(this.timeout, that.timeout).append(this.overrideKey, that.overrideKey).append(this.disableExec, that.disableExec);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return super.addToHashCode(builder).append((Object)this.keyInfo).append(this.timeout).append(this.overrideKey).append(this.disableExec);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return super.addToToString(builder).append("keyInfo", (Object)this.keyInfo).append("timeout", this.timeout).append("overrideKey", this.overrideKey).append("disableExec", this.disableExec);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        BapSshHostConfiguration thatHostConfiguration = (BapSshHostConfiguration)((Object)that);
        return this.addToEquals(new EqualsBuilder(), thatHostConfiguration).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

