/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.options;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.options.PublisherOptions;
import jenkins.plugins.publish_over.view_defaults.BapPublisher.Messages;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import org.kohsuke.stapler.DataBoundConstructor;

public class SshOverridePublisherDefaults
implements PublisherOptions,
Describable<SshOverridePublisherDefaults> {
    private final String configName;
    private final boolean useWorkspaceInPromotion;
    private final boolean usePromotionTimestamp;
    private final boolean verbose;
    private final Jenkins j = Jenkins.getInstanceOrNull();

    @DataBoundConstructor
    public SshOverridePublisherDefaults(String configName, boolean useWorkspaceInPromotion, boolean usePromotionTimestamp, boolean verbose) {
        this.configName = configName;
        this.usePromotionTimestamp = usePromotionTimestamp;
        this.useWorkspaceInPromotion = useWorkspaceInPromotion;
        this.verbose = verbose;
    }

    public String getConfigName() {
        return this.configName;
    }

    public boolean isUseWorkspaceInPromotion() {
        return this.useWorkspaceInPromotion;
    }

    public boolean isUsePromotionTimestamp() {
        return this.usePromotionTimestamp;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public SshOverridePublisherDefaultsDescriptor getDescriptor() {
        if (this.j != null) {
            return (SshOverridePublisherDefaultsDescriptor)this.j.getDescriptorByType(SshOverridePublisherDefaultsDescriptor.class);
        }
        throw new NullPointerException("Jenkins is not ready on going to be offline...");
    }

    @Extension
    public static class SshOverridePublisherDefaultsDescriptor
    extends Descriptor<SshOverridePublisherDefaults> {
        public String getDisplayName() {
            return "SshOverridePublisherDefaultsDescriptor - not visible ...";
        }

        public BapSshPublisherPlugin.Descriptor getPublisherPluginDescriptor() {
            return (BapSshPublisherPlugin.Descriptor)Jenkins.getActiveInstance().getDescriptorByType(BapSshPublisherPlugin.Descriptor.class);
        }

        public Messages getCommonFieldNames() {
            return new Messages();
        }
    }
}

