/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import hudson.FilePath;
import hudson.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Stack;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPDefaultClient;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_ssh.BapSshTransfer;
import jenkins.plugins.publish_over_ssh.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BapSshClient
extends BPDefaultClient<BapSshTransfer> {
    private static final transient Log LOG = LogFactory.getLog(BapSshClient.class);
    private final BPBuildInfo buildInfo;
    private final Stack<Session> sessions = new Stack();
    private final boolean disableExec;
    private ChannelSftp sftp;

    public BapSshClient(BPBuildInfo buildInfo, Session session) {
        this(buildInfo, session, false);
    }

    public BapSshClient(BPBuildInfo buildInfo, Session session, boolean disableExec) {
        this.buildInfo = buildInfo;
        this.disableExec = disableExec;
        this.addSession(session);
    }

    public void addSession(Session session) {
        this.sessions.push(session);
    }

    public boolean isDisableExec() {
        return this.disableExec;
    }

    public BPBuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public Session getSession() {
        return this.sessions.peek();
    }

    public void beginTransfers(BapSshTransfer transfer) {
        if (this.disableExec) {
            if (!transfer.hasConfiguredSourceFiles()) {
                throw new BapPublisherException(Messages.exception_badTransferConfig_noExec());
            }
        } else if (!transfer.hasConfiguredSourceFiles() && !transfer.hasExecCommand()) {
            throw new BapPublisherException(Messages.exception_badTransferConfig());
        }
    }

    public boolean changeDirectory(String directory) {
        try {
            if (!this.sftp.stat(directory).isDir()) {
                return false;
            }
        }
        catch (SftpException sftpe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.log_sftp_stat(directory, sftpe.getLocalizedMessage()));
            }
            return false;
        }
        try {
            this.buildInfo.printIfVerbose(Messages.console_cd(directory));
            this.sftp.cd(directory);
            this.success();
            return true;
        }
        catch (SftpException sftpe) {
            throw new BapPublisherException(Messages.exception_cwdException(directory, sftpe.getLocalizedMessage()), (Throwable)sftpe);
        }
    }

    public boolean makeDirectory(String directory) {
        if (this.hasSubDirs(directory)) {
            return false;
        }
        try {
            this.buildInfo.printIfVerbose(Messages.console_mkdir(directory));
            this.sftp.mkdir(directory);
            this.success();
            return true;
        }
        catch (SftpException sftpe) {
            this.buildInfo.printIfVerbose(Messages.console_failure(sftpe.getLocalizedMessage()));
            return false;
        }
    }

    public void transferFile(BapSshTransfer bapSshTransfer, FilePath filePath, InputStream inputStream) throws SftpException {
        this.buildInfo.printIfVerbose(Messages.console_put(filePath.getName()));
        this.sftp.put(inputStream, filePath.getName());
        this.success();
    }

    private void success() {
        this.buildInfo.printIfVerbose(Messages.console_success());
    }

    private boolean hasSubDirs(String directory) {
        return directory.contains("/") || directory.contains("\\");
    }

    public void endTransfers(BapSshTransfer transfer) {
        if (!this.disableExec && transfer.hasExecCommand()) {
            this.exec(transfer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(BapSshTransfer transfer) {
        ChannelExec exec = null;
        try {
            exec = this.openExecChannel();
            exec.setPty(transfer.isUsePty());
            exec.setAgentForwarding(transfer.isUseAgentForwarding());
            exec.setInputStream(null);
            exec.setOutputStream((OutputStream)this.buildInfo.getListener().getLogger(), true);
            exec.setErrStream((OutputStream)this.buildInfo.getListener().getLogger(), true);
            this.connectExecChannel(exec, Util.replaceMacro((String)transfer.getExecCommand(), (Map)this.buildInfo.getEnvVars()));
            this.waitForExec(exec, transfer.getExecTimeout());
            int status = exec.getExitStatus();
            if (status != 0) {
                throw new BapPublisherException(Messages.exception_exec_exitStatus(status));
            }
        }
        finally {
            this.disconnectExecQuietly(exec);
        }
    }

    private void connectExecChannel(ChannelExec exec, String command) {
        exec.setCommand(command);
        this.buildInfo.println(Messages.console_exec_connecting(command));
        try {
            exec.connect(this.getSession().getTimeout());
        }
        catch (JSchException jse) {
            String message = Messages.exception_exec_connect(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapPublisherException(message);
        }
        this.buildInfo.printIfVerbose(Messages.console_exec_connected());
    }

    private ChannelExec openExecChannel() {
        this.buildInfo.printIfVerbose(Messages.console_exec_opening());
        try {
            ChannelExec exec = (ChannelExec)this.getSession().openChannel("exec");
            this.buildInfo.printIfVerbose(Messages.console_exec_opened());
            return exec;
        }
        catch (JSchException jse) {
            String message = Messages.exception_exec_open(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapPublisherException(message);
        }
    }

    public void disconnectExecQuietly(ChannelExec exec) {
        try {
            this.disconnectExec(exec);
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.exception_disconnect_exec(e.getLocalizedMessage()));
        }
    }

    private void disconnectExec(ChannelExec exec) {
        if (exec == null) {
            return;
        }
        if (exec.isConnected()) {
            exec.disconnect();
        }
    }

    public void disconnect() {
        this.disconnectSftp();
        this.disconnectSession();
    }

    private void disconnectSftp() {
        if (this.sftp == null) {
            return;
        }
        if (this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
    }

    private void disconnectSession() {
        while (!this.sessions.empty()) {
            Session session = this.sessions.pop();
            if (!session.isConnected()) continue;
            session.disconnect();
        }
    }

    public void disconnectQuietly() {
        try {
            this.disconnectSftp();
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.exception_disconnect_sftp(e.getLocalizedMessage()));
        }
        try {
            this.disconnectSession();
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.exception_disconnect_session(e.getLocalizedMessage()));
        }
    }

    private void waitForExec(ChannelExec exec, long timeout) {
        long start = System.currentTimeMillis();
        ExecCheckThread waiter = new ExecCheckThread(exec);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long duration = System.currentTimeMillis() - start;
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        if (!exec.isClosed()) {
            throw new BapPublisherException(Messages.exception_exec_timeout(duration));
        }
        this.buildInfo.println(Messages.console_exec_completed(duration));
    }

    private static final class ExecCheckThread
    extends Thread {
        private static final int POLL_TIME = 200;
        private final ChannelExec exec;

        ExecCheckThread(ChannelExec exec) {
            this.exec = exec;
        }

        @Override
        public void run() {
            try {
                while (!this.exec.isClosed()) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

