/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh.options;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import jenkins.plugins.publish_over.options.RetryOptions;
import jenkins.plugins.publish_over.view_defaults.Retry.Messages;
import jenkins.plugins.publish_over_ssh.BapSshRetry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SshOverrideRetryDefaults
implements RetryOptions,
Describable<SshOverrideRetryDefaults> {
    private final int retries;
    private final long retryDelay;

    @DataBoundConstructor
    public SshOverrideRetryDefaults(int retries, long retryDelay) {
        this.retries = retries;
        this.retryDelay = retryDelay;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public SshOverrideRetryDefaultsDescriptor getDescriptor() {
        return (SshOverrideRetryDefaultsDescriptor)Hudson.getInstance().getDescriptorByType(SshOverrideRetryDefaultsDescriptor.class);
    }

    @Extension
    public static class SshOverrideRetryDefaultsDescriptor
    extends Descriptor<SshOverrideRetryDefaults> {
        public String getDisplayName() {
            return "SshOverrideRetryDefaultsDescriptor - not visible ...";
        }

        public FormValidation doCheckRetries(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckRetryDelay(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public Messages getCommonFieldNames() {
            return new Messages();
        }

        public String getConfigPage() {
            return this.getViewPage(BapSshRetry.class, "config.jelly");
        }
    }
}

