/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Hudson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_ssh.BapSshClient;
import jenkins.plugins.publish_over_ssh.BapSshCommonConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshCredentials;
import jenkins.plugins.publish_over_ssh.BapSshKeyInfo;
import jenkins.plugins.publish_over_ssh.BapSshPublisher;
import jenkins.plugins.publish_over_ssh.BapSshSftpSetupException;
import jenkins.plugins.publish_over_ssh.BapSshUtil;
import jenkins.plugins.publish_over_ssh.Messages;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshHostConfigurationDescriptor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BapSshHostConfiguration
extends BPHostConfiguration<BapSshClient, BapSshCommonConfiguration>
implements Describable<BapSshHostConfiguration> {
    static final String LOCALHOST = "127.0.0.1";
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 22;
    public static final int DEFAULT_TIMEOUT = 300000;
    public static final String CONFIG_KEY_PREFERRED_AUTHENTICATIONS = "PreferredAuthentications";
    private static final Log LOG = LogFactory.getLog(BapSshHostConfiguration.class);
    public static final String DEFAULT_JUMP_HOST = "";
    public static final String HTTP_PROXY_TYPE = "http";
    public static final String SOCKS_4_PROXY_TYPE = "socks4";
    public static final String SOCKS_5_PROXY_TYPE = "socks5";
    private int timeout;
    private boolean overrideKey;
    private boolean disableExec;
    private final BapSshKeyInfo keyInfo;
    private String jumpHost;
    private String proxyType;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public BapSshHostConfiguration() {
        super(null, null, null, null, null, 0);
        this.keyInfo = new BapSshKeyInfo(null, null, null);
    }

    @DataBoundConstructor
    public BapSshHostConfiguration(String name, String hostname, String username, String encryptedPassword, String remoteRootDir, int port, int timeout, boolean overrideKey, String keyPath, String key, boolean disableExec) {
        super(name, hostname, username, null, remoteRootDir, port);
        this.timeout = timeout;
        this.overrideKey = overrideKey;
        this.keyInfo = new BapSshKeyInfo(encryptedPassword, key, keyPath);
        this.disableExec = disableExec;
    }

    @DataBoundSetter
    public void setJumpHost(String jumpHost) {
        this.jumpHost = jumpHost;
    }

    public String getJumpHost() {
        return this.jumpHost;
    }

    @DataBoundSetter
    public void setName(String name) {
        super.setName(name);
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        super.setHostname(hostname);
    }

    @DataBoundSetter
    public void setRemoteRootDir(String remoteRootDir) {
        super.setRemoteRootDir(remoteRootDir);
    }

    @DataBoundSetter
    public void setPort(int port) {
        super.setPort(port);
    }

    public int getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected final String getPassword() {
        return this.keyInfo.getPassphrase();
    }

    public final void setPassword(String password) {
        this.keyInfo.setPassphrase(password);
    }

    @DataBoundSetter
    public final String getEncryptedPassword() {
        return this.keyInfo.getEncryptedPassphrase();
    }

    @DataBoundSetter
    public void setEncryptedPassword(String encryptedPassword) {
        this.keyInfo.setPassphrase(encryptedPassword);
    }

    public String getKeyPath() {
        return this.keyInfo.getKeyPath();
    }

    public void setKeyPath(String keyPath) {
        this.keyInfo.setKeyPath(keyPath);
    }

    public String getKey() {
        return this.keyInfo.getKey();
    }

    public void setKey(String key) {
        this.keyInfo.setKey(key);
    }

    public boolean isOverrideKey() {
        return this.overrideKey;
    }

    @DataBoundSetter
    public void setOverrideKey(boolean overrideKey) {
        this.overrideKey = overrideKey;
    }

    public boolean isDisableExec() {
        return this.disableExec;
    }

    @DataBoundSetter
    public void setDisableExec(boolean disableExec) {
        this.disableExec = disableExec;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @DataBoundSetter
    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    @DataBoundSetter
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @DataBoundSetter
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @DataBoundSetter
    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    @DataBoundSetter
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isEffectiveDisableExec() {
        return ((BapSshCommonConfiguration)this.getCommonConfig()).isDisableAllExec() || this.disableExec;
    }

    private BapSshKeyInfo getEffectiveKeyInfo(BPBuildInfo buildInfo) {
        BapSshCredentials publisherCredentials = BapSshHostConfiguration.getPublisherOverrideCredentials(buildInfo);
        if (publisherCredentials != null) {
            return publisherCredentials;
        }
        return this.overrideKey ? this.keyInfo : (BapSshKeyInfo)this.getCommonConfig();
    }

    public BapSshClient createClient(BPBuildInfo buildInfo, BapPublisher publisher) {
        if (publisher instanceof BapSshPublisher) {
            return this.createClient(buildInfo, ((BapSshPublisher)publisher).isSftpRequired());
        }
        throw new IllegalArgumentException("Invalid type passed to createClient");
    }

    public BapSshClient createClient(BPBuildInfo buildInfo) {
        return this.createClient(buildInfo, true);
    }

    public BapSshClient createClient(BPBuildInfo buildInfo, boolean connectSftp) {
        JSch ssh = this.createJSch();
        String[] hosts = this.getHosts();
        Session session = this.createSession(buildInfo, ssh, hosts[0], this.getPort());
        this.configureAuthentication(buildInfo, ssh, session);
        BapSshClient bapClient = new BapSshClient(buildInfo, session, this.isEffectiveDisableExec());
        try {
            this.connect(buildInfo, session);
            for (int i = 1; i < hosts.length; ++i) {
                int assignedPort = session.setPortForwardingL(0, hosts[i], this.getPort());
                session = this.createSession(buildInfo, ssh, LOCALHOST, assignedPort);
                bapClient.addSession(session);
                this.configureAuthentication(buildInfo, ssh, session);
                this.connect(buildInfo, session);
            }
            if (connectSftp) {
                this.setupSftp(bapClient);
            }
        }
        catch (IOException e) {
            bapClient.disconnectQuietly();
            throw new BapPublisherException(Messages.exception_failedToCreateClient(e.getLocalizedMessage()), (Throwable)e);
        }
        catch (JSchException e) {
            bapClient.disconnectQuietly();
            throw new BapPublisherException(Messages.exception_failedToCreateClient(e.getLocalizedMessage()), (Throwable)e);
        }
        catch (BapPublisherException e) {
            bapClient.disconnectQuietly();
            throw new BapPublisherException(Messages.exception_failedToCreateClient(e.getLocalizedMessage()), (Throwable)e);
        }
        return bapClient;
    }

    String[] getHosts() {
        return HostsHelper.getHosts(this.getHostnameTrimmed(), this.jumpHost);
    }

    private void configureAuthentication(BPBuildInfo buildInfo, JSch ssh, Session session) {
        BapSshKeyInfo keyInfo = this.getEffectiveKeyInfo(buildInfo);
        Properties sessionProperties = this.getSessionProperties();
        if (keyInfo.useKey()) {
            this.setKey(buildInfo, ssh, keyInfo);
            sessionProperties.put(CONFIG_KEY_PREFERRED_AUTHENTICATIONS, "publickey");
        } else {
            session.setPassword(Util.fixNull((String)keyInfo.getPassphrase()));
            sessionProperties.put(CONFIG_KEY_PREFERRED_AUTHENTICATIONS, "keyboard-interactive,password");
        }
        session.setConfig(sessionProperties);
    }

    private void setupSftp(BapSshClient bapClient) throws IOException {
        BPBuildInfo buildInfo = bapClient.getBuildInfo();
        ChannelSftp sftp = this.openSftpChannel(buildInfo, bapClient.getSession());
        bapClient.setSftp(sftp);
        this.connectSftpChannel(buildInfo, sftp);
        this.changeToRootDirectory((BPClient)bapClient);
        this.setRootDirectoryInClient(bapClient, sftp);
    }

    private void setKey(BPBuildInfo buildInfo, JSch ssh, BapSshKeyInfo keyInfo) {
        try {
            ssh.addIdentity("TheKey", keyInfo.getEffectiveKey(buildInfo), null, BapSshUtil.toBytes(keyInfo.getPassphrase()));
        }
        catch (JSchException jsche) {
            throw new BapPublisherException(Messages.exception_addIdentity(jsche.getLocalizedMessage()), (Throwable)jsche);
        }
    }

    private void setRootDirectoryInClient(BapSshClient client, ChannelSftp sftp) throws IOException {
        if (this.isDirectoryAbsolute(this.getRemoteRootDir())) {
            client.setAbsoluteRemoteRoot(this.getRemoteRootDir());
        } else {
            client.setAbsoluteRemoteRoot(this.getRootDirectoryFromPwd(client, sftp));
        }
    }

    private String getRootDirectoryFromPwd(BapSshClient client, ChannelSftp sftp) {
        BPBuildInfo buildInfo = client.getBuildInfo();
        buildInfo.printIfVerbose(Messages.console_usingPwd());
        try {
            String pwd = sftp.pwd();
            if (!this.isDirectoryAbsolute(pwd)) {
                throw new BapPublisherException(Messages.exception_pwdNotAbsolute(pwd));
            }
            return pwd;
        }
        catch (SftpException sftpe) {
            String message = Messages.exception_pwd(sftpe.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)sftpe);
            throw new BapPublisherException(message);
        }
    }

    private void connectSftpChannel(BPBuildInfo buildInfo, ChannelSftp channel) {
        buildInfo.printIfVerbose(Messages.console_sftp_connecting());
        try {
            channel.connect(this.getTimeout());
        }
        catch (JSchException jse) {
            String message = Messages.exception_sftp_connect(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapSshSftpSetupException(message);
        }
        buildInfo.printIfVerbose(Messages.console_sftp_connected());
    }

    private ChannelSftp openSftpChannel(BPBuildInfo buildInfo, Session session) {
        ChannelSftp sftp;
        buildInfo.printIfVerbose(Messages.console_sftp_opening());
        try {
            sftp = (ChannelSftp)session.openChannel("sftp");
        }
        catch (JSchException jse) {
            String message = Messages.exception_sftp_open(jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapSshSftpSetupException(message);
        }
        buildInfo.printIfVerbose(Messages.console_sftp_opened());
        return sftp;
    }

    private Properties getSessionProperties() {
        Properties props = new Properties();
        props.put("StrictHostKeyChecking", "no");
        return props;
    }

    private void connect(BPBuildInfo buildInfo, Session session) {
        buildInfo.printIfVerbose(Messages.console_session_connecting());
        try {
            session.connect(this.getTimeout());
        }
        catch (JSchException jse) {
            String message = Messages.exception_session_connect(this.getName(), jse.getLocalizedMessage());
            LOG.warn((Object)message, (Throwable)jse);
            throw new BapPublisherException(message);
        }
        buildInfo.printIfVerbose(Messages.console_session_connected());
    }

    private Session createSession(BPBuildInfo buildInfo, JSch ssh, String hostname, int port) {
        BapSshCredentials overrideCreds = BapSshHostConfiguration.getPublisherOverrideCredentials(buildInfo);
        String username = overrideCreds == null ? this.getUsername() : overrideCreds.getUsername();
        try {
            buildInfo.printIfVerbose(Messages.console_session_creating(username, hostname, port));
            Session session = ssh.getSession(username, hostname, port);
            if (StringUtils.isNotEmpty((String)this.proxyType) && StringUtils.isNotEmpty((String)this.proxyHost)) {
                if (StringUtils.equals((String)HTTP_PROXY_TYPE, (String)this.proxyType)) {
                    ProxyHTTP proxyHTTP = new ProxyHTTP(this.proxyHost, this.proxyPort);
                    if (StringUtils.isNotEmpty((String)this.proxyUser) && StringUtils.isNotEmpty((String)this.proxyPassword)) {
                        proxyHTTP.setUserPasswd(this.proxyUser, this.proxyPassword);
                    } else {
                        proxyHTTP.setUserPasswd(null, null);
                    }
                    session.setProxy((Proxy)proxyHTTP);
                } else if (StringUtils.equals((String)SOCKS_4_PROXY_TYPE, (String)this.proxyType)) {
                    ProxySOCKS4 proxySocks4 = new ProxySOCKS4(this.proxyHost, this.proxyPort);
                    if (StringUtils.isNotEmpty((String)this.proxyUser) && StringUtils.isNotEmpty((String)this.proxyPassword)) {
                        proxySocks4.setUserPasswd(this.proxyUser, this.proxyPassword);
                    } else {
                        proxySocks4.setUserPasswd(null, null);
                    }
                    session.setProxy((Proxy)proxySocks4);
                } else if (StringUtils.equals((String)SOCKS_5_PROXY_TYPE, (String)this.proxyType)) {
                    ProxySOCKS5 proxySocks5 = new ProxySOCKS5(this.proxyHost, this.proxyPort);
                    if (StringUtils.isNotEmpty((String)this.proxyUser) && StringUtils.isNotEmpty((String)this.proxyPassword)) {
                        proxySocks5.setUserPasswd(this.proxyUser, this.proxyPassword);
                    } else {
                        proxySocks5.setUserPasswd(null, null);
                    }
                    session.setProxy((Proxy)proxySocks5);
                }
            }
            return session;
        }
        catch (JSchException jse) {
            throw new BapPublisherException(Messages.exception_session_create(username, this.getHostnameTrimmed(), this.getPort(), jse.getLocalizedMessage()), (Throwable)jse);
        }
    }

    private static BapSshCredentials getPublisherOverrideCredentials(BPBuildInfo buildInfo) {
        return (BapSshCredentials)buildInfo.get("credentials");
    }

    protected JSch createJSch() {
        return new JSch();
    }

    public BapSshHostConfigurationDescriptor getDescriptor() {
        return (BapSshHostConfigurationDescriptor)Hudson.getInstance().getDescriptorByType(BapSshHostConfigurationDescriptor.class);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BapSshHostConfiguration that) {
        return super.addToEquals(builder, (BPHostConfiguration)that).append((Object)this.keyInfo, (Object)that.keyInfo).append(this.timeout, that.timeout).append(this.overrideKey, that.overrideKey).append((Object)this.jumpHost, (Object)that.jumpHost).append(this.disableExec, that.disableExec).append((Object)this.proxyType, (Object)that.proxyType).append((Object)this.proxyHost, (Object)that.proxyHost).append(this.proxyPort, that.proxyPort).append((Object)this.proxyUser, (Object)that.proxyUser).append((Object)this.proxyPassword, (Object)that.proxyPassword);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return super.addToHashCode(builder).append((Object)this.keyInfo).append(this.timeout).append(this.overrideKey).append((Object)this.jumpHost).append(this.disableExec).append((Object)this.proxyType).append((Object)this.proxyHost).append(this.proxyPort).append((Object)this.proxyUser).append((Object)this.proxyPassword);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return super.addToToString(builder).append("keyInfo", (Object)this.keyInfo).append("timeout", this.timeout).append("overrideKey", this.overrideKey).append("jumpHost", (Object)this.jumpHost).append("disableExec", this.disableExec).append("proxyType", (Object)this.proxyType).append("proxyHost", (Object)this.proxyHost).append("proxyPort", this.proxyPort).append("proxyUser", (Object)this.proxyUser).append("proxyPassword", (Object)this.proxyPassword);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        BapSshHostConfiguration thatHostConfiguration = (BapSshHostConfiguration)((Object)that);
        return this.addToEquals(new EqualsBuilder(), thatHostConfiguration).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public Object readResolve() {
        return super.readResolve();
    }

    static class HostsHelper {
        HostsHelper() {
        }

        static String[] getHosts(String target, String jumpHosts) {
            ArrayList<String> hosts = new ArrayList<String>();
            if (jumpHosts != null) {
                String[] jumpHostsList;
                for (String host : jumpHostsList = jumpHosts.split(" |;|,")) {
                    if (!StringUtils.isNotBlank((String)host)) continue;
                    hosts.add(host);
                }
            }
            hosts.add(target);
            return hosts.toArray(new String[hosts.size()]);
        }
    }
}

