/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import jenkins.plugins.publish_over.BPTransfer;
import jenkins.plugins.publish_over_ssh.BapSshHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import jenkins.plugins.publish_over_ssh.BapTransfer;
import jenkins.plugins.publish_over_ssh.Messages;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshTransfer
extends BapTransfer
implements Describable<BapSshTransfer> {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public BapSshTransfer(String sourceFiles, String excludes, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout) {
        super(sourceFiles, excludes, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, execCommand, execTimeout);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.createEqualsBuilder((BapSshTransfer)((Object)that)).isEquals();
    }

    @Override
    public int hashCode() {
        return this.createHashCodeBuilder().toHashCode();
    }

    @Override
    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BapSshTransfer> {
        public String getDisplayName() {
            return Messages.transfer_descriptor_displayName();
        }

        public boolean canUseExcludes() {
            return BPTransfer.canUseExcludes();
        }

        public static int getDefaultExecTimeout() {
            return 120000;
        }

        public FormValidation doCheckExecTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckSourceFiles(@QueryParameter String configName, @QueryParameter String sourceFiles, @QueryParameter String execCommand) {
            if (Util.fixEmptyAndTrim((String)configName) != null) {
                BapSshPublisherPlugin.Descriptor pluginDescriptor = (BapSshPublisherPlugin.Descriptor)Hudson.getInstance().getDescriptorByType(BapSshPublisherPlugin.Descriptor.class);
                BapSshHostConfiguration hostConfig = (BapSshHostConfiguration)pluginDescriptor.getConfiguration(configName);
                if (hostConfig == null) {
                    return FormValidation.error((String)Messages.descriptor_sourceFiles_check_configNotFound(configName));
                }
                if (hostConfig.isEffectiveDisableExec()) {
                    return FormValidation.validateRequired((String)sourceFiles);
                }
            }
            return this.checkTransferSet(sourceFiles, execCommand);
        }

        public FormValidation doCheckExecCommand(@QueryParameter String sourceFiles, @QueryParameter String execCommand) {
            return this.checkTransferSet(sourceFiles, execCommand);
        }

        private FormValidation checkTransferSet(String sourceFiles, String execCommand) {
            return this.haveAtLeastOne(sourceFiles, execCommand) ? FormValidation.ok() : FormValidation.error((String)Messages.descriptor_sourceOrExec());
        }

        private boolean haveAtLeastOne(String ... values) {
            for (String value : values) {
                if (Util.fixEmptyAndTrim((String)value) == null) continue;
                return true;
            }
            return false;
        }
    }
}

