/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import jenkins.plugins.publish_over.BPValidators;
import jenkins.plugins.publish_over_ssh.BapHostConfiguration;
import jenkins.plugins.publish_over_ssh.BapSshPublisherPlugin;
import jenkins.plugins.publish_over_ssh.Messages;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshHostConfiguration
extends BapHostConfiguration
implements Describable<BapSshHostConfiguration> {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public BapSshHostConfiguration(String name, String hostname, String username, String password, String remoteRootDir, int port, int timeout, boolean overrideKey, String keyPath, String key, boolean disableExec) {
        super(name, hostname, username, password, remoteRootDir, port, timeout, overrideKey, keyPath, key, disableExec);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        BapSshHostConfiguration thatHostConfig = (BapSshHostConfiguration)((Object)that);
        return this.createEqualsBuilder(thatHostConfig).isEquals();
    }

    @Override
    public int hashCode() {
        return this.createHashCodeBuilder().toHashCode();
    }

    @Override
    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BapSshHostConfiguration> {
        public String getDisplayName() {
            return Messages.global_common_descriptor();
        }

        public int getDefaultPort() {
            return 22;
        }

        public int getDefaultTimeout() {
            return 300000;
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return BPValidators.validateName((String)value);
        }

        public FormValidation doCheckHostname(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckUsername(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckPort(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckKeyPath(@QueryParameter String value) {
            return BPValidators.validateFileOnMaster((String)value);
        }

        public FormValidation doTestConnection(StaplerRequest request, StaplerResponse response) {
            BapSshPublisherPlugin.Descriptor pluginDescriptor = (BapSshPublisherPlugin.Descriptor)Hudson.getInstance().getDescriptorByType(BapSshPublisherPlugin.Descriptor.class);
            return pluginDescriptor.doTestConnection(request, response);
        }
    }
}

