/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox.pve2api;

import hudson.util.Secret;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;

public class Connector {
    public static final long WAIT_TIME_MS = 1000L;
    protected Integer port = 8006;
    protected String username;
    protected String realm;
    protected Secret password;
    protected String baseURL;
    private String authTicket;
    private Date authTicketIssuedTimestamp;
    private String csrfPreventionToken;
    private UnirestInstance unirest;
    private static final Logger LOGGER = Logger.getLogger(Connector.class.getName());

    public Connector(String hostname, String username, String realm, Secret password) {
        this(hostname, username, realm, password, false);
    }

    public Connector(String hostname, String username, String realm, Secret password, Boolean ignoreSSL) {
        try {
            URI uri = new URI("https://" + hostname);
            if (uri.getPort() != -1) {
                hostname = uri.getHost();
                this.port = uri.getPort();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.username = username;
        this.realm = realm;
        this.password = password;
        this.unirest = Unirest.spawnInstance();
        this.unirest.config().verifySsl(ignoreSSL == false).reset();
        this.authTicketIssuedTimestamp = null;
        this.baseURL = "https://" + hostname + ":" + this.port.toString() + "/api2/json/";
    }

    public void login() throws LoginException {
        JSONObject authTickets = ((JsonNode)this.unirest.post(this.baseURL + "access/ticket").field("username", (Object)(this.username + "@" + this.realm)).field("password", this.password.getPlainText()).asJson().getBody()).getObject();
        try {
            JSONObject data = authTickets.getJSONObject("data");
            this.authTicket = data.get("ticket").toString();
            this.csrfPreventionToken = data.get("CSRFPreventionToken").toString();
            this.authTicketIssuedTimestamp = new Date();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed reading JSON response", e);
            throw new LoginException("Failed reading JSON response");
        }
    }

    public void checkIfAuthTicketIsValid() throws LoginException {
        if (this.authTicketIssuedTimestamp == null || this.authTicketIssuedTimestamp.getTime() <= new Date().getTime() - 0x6DDD00L) {
            this.login();
        }
    }

    private HttpResponse<JsonNode> JSONResource(HttpRequest req) throws LoginException {
        this.checkIfAuthTicketIsValid();
        return req.header("Cookie", "PVEAuthCookie=" + this.authTicket).header("CSRFPreventionToken", this.csrfPreventionToken).asJson();
    }

    private JsonNode getJSONResource(String apiUrl) throws LoginException {
        return (JsonNode)this.JSONResource((HttpRequest)this.unirest.get(this.baseURL + apiUrl)).getBody();
    }

    private JsonNode postJSONResource(String apiUrl, String body) throws LoginException {
        return (JsonNode)this.JSONResource((HttpRequest)((HttpRequestWithBody)this.unirest.post(this.baseURL + apiUrl).header("Content-Type", "application/x-www-form-urlencoded")).body(body)).getBody();
    }

    public List<String> getNodes() throws LoginException {
        ArrayList<String> res = new ArrayList<String>();
        JSONArray nodes = this.getJSONResource("nodes").getObject().getJSONArray("data");
        for (int i = 0; i < nodes.length(); ++i) {
            res.add(nodes.getJSONObject(i).getString("node"));
        }
        return res;
    }

    public JSONObject getTaskStatus(String node, String taskId) throws LoginException {
        JsonNode response = this.getJSONResource("nodes/" + node + "/tasks/" + taskId + "/status");
        return response.getObject().getJSONObject("data");
    }

    public JSONObject getQemuMachineStatus(String node, Integer vmid) throws LoginException {
        JsonNode response = this.getJSONResource("nodes/" + node + "/qemu/" + vmid + "/status/current");
        return response.getObject().getJSONObject("data");
    }

    public Boolean isQemuMachineRunning(String node, Integer vmid) throws LoginException {
        JSONObject QemuMachineStatus = null;
        Boolean isRunning = true;
        QemuMachineStatus = this.getQemuMachineStatus(node, vmid);
        isRunning = QemuMachineStatus.getString("status").equals("running");
        return isRunning;
    }

    public JSONObject waitForTaskToFinish(String node, String taskId) throws LoginException, InterruptedException {
        JSONObject lastTaskStatus = null;
        Boolean isRunning = true;
        while (isRunning.booleanValue()) {
            lastTaskStatus = this.getTaskStatus(node, taskId);
            isRunning = lastTaskStatus.getString("status").equals("running");
            if (!isRunning.booleanValue()) continue;
            Thread.sleep(1000L);
        }
        return lastTaskStatus;
    }

    public HashMap<String, Integer> getQemuMachines(String node) throws LoginException {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        JSONArray qemuVMs = this.getJSONResource("nodes/" + node + "/qemu").getObject().getJSONArray("data");
        for (int i = 0; i < qemuVMs.length(); ++i) {
            JSONObject vm = qemuVMs.getJSONObject(i);
            res.put(vm.getString("name"), vm.getInt("vmid"));
        }
        return res;
    }

    public List<String> getQemuMachineSnapshots(String node, Integer vmid) throws LoginException {
        ArrayList<String> res = new ArrayList<String>();
        JSONArray snapshots = this.getJSONResource("nodes/" + node + "/qemu/" + vmid.toString() + "/snapshot").getObject().getJSONArray("data");
        for (int i = 0; i < snapshots.length(); ++i) {
            res.add(snapshots.getJSONObject(i).getString("name"));
        }
        return res;
    }

    public String rollbackQemuMachineSnapshot(String node, Integer vmid, String snapshotName) throws LoginException {
        return this.postJSONResource("nodes/" + node + "/qemu/" + vmid.toString() + "/snapshot/" + snapshotName + "/rollback", "").getObject().getString("data");
    }

    public String startQemuMachine(String node, Integer vmid) throws LoginException {
        return this.postJSONResource("nodes/" + node + "/qemu/" + vmid.toString() + "/status/start", "").getObject().getString("data");
    }

    public String stopQemuMachine(String node, Integer vmid) throws LoginException {
        return this.postJSONResource("nodes/" + node + "/qemu/" + vmid.toString() + "/status/stop", "").getObject().getString("data");
    }

    public String shutdownQemuMachine(String node, Integer vmid) throws LoginException {
        return this.postJSONResource("nodes/" + node + "/qemu/" + vmid.toString() + "/status/shutdown", "").getObject().getString("data");
    }

    protected void finalize() {
        this.unirest.shutDown();
    }
}

