/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.proxmox.pve2api.Connector;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Datacenter
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(Datacenter.class.getName());
    private final String hostname;
    private final String username;
    private final String realm;
    private final Secret password;
    private final Boolean ignoreSSL;
    private transient Connector pveConnector;

    @DataBoundConstructor
    public Datacenter(String hostname, String username, String realm, Secret password, Boolean ignoreSSL) {
        super("Datacenter(proxmox)");
        this.hostname = hostname;
        this.username = username;
        this.realm = realm;
        this.password = password;
        this.ignoreSSL = ignoreSSL;
        this.pveConnector = null;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public Secret getPassword() {
        return this.password;
    }

    public Boolean getIgnoreSSL() {
        return this.ignoreSSL;
    }

    public String getDatacenterDescription() {
        return this.username + "@" + this.realm + " - " + this.hostname;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public Connector proxmoxInstance() {
        if (this.pveConnector == null) {
            this.pveConnector = new Connector(this.hostname, this.username, this.realm, this.password, this.ignoreSSL);
        }
        return this.pveConnector;
    }

    public List<String> getNodes() {
        Connector pveConnector = this.proxmoxInstance();
        try {
            return pveConnector.getNodes();
        }
        catch (LoginException e) {
            return new ArrayList<String>();
        }
    }

    public HashMap<String, Integer> getQemuMachines(String node) {
        if (node == null || node.isEmpty()) {
            return new HashMap<String, Integer>();
        }
        Connector pveConnector = this.proxmoxInstance();
        try {
            return pveConnector.getQemuMachines(node);
        }
        catch (LoginException e) {
            return new HashMap<String, Integer>();
        }
    }

    public List<String> getQemuMachineSnapshots(String node, Integer vmid) {
        if (node == null || node.isEmpty() || vmid < 1) {
            return new ArrayList<String>();
        }
        Connector pveConnector = this.proxmoxInstance();
        try {
            return pveConnector.getQemuMachineSnapshots(node, vmid);
        }
        catch (LoginException e) {
            return new ArrayList<String>();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Proxmox Datacenter";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.save();
            return super.configure(req, o);
        }

        private FormValidation fieldNotSpecifiedError(String fieldName) {
            return FormValidation.error((String)(fieldName + " not specified"));
        }

        private FormValidation emptyStringValidation(String fieldName, String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return this.fieldNotSpecifiedError(fieldName);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHostname(@QueryParameter String value) {
            return this.emptyStringValidation("Hostname", value);
        }

        public FormValidation doCheckUsername(@QueryParameter String value) {
            return this.emptyStringValidation("Username", value);
        }

        public FormValidation doCheckRealm(@QueryParameter String value) {
            return this.emptyStringValidation("Realm", value);
        }

        public FormValidation doCheckPassword(@QueryParameter Secret value) {
            return this.emptyStringValidation("Password", value.getPlainText());
        }

        public FormValidation doTestConnection(@QueryParameter String hostname, @QueryParameter String username, @QueryParameter String realm, @QueryParameter Secret password, @QueryParameter Boolean ignoreSSL) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                if (hostname.isEmpty()) {
                    return this.fieldNotSpecifiedError("Hostname");
                }
                if (username.isEmpty()) {
                    return this.fieldNotSpecifiedError("Username");
                }
                if (realm.isEmpty()) {
                    return this.fieldNotSpecifiedError("Realm");
                }
                if (password.getPlainText().isEmpty()) {
                    return this.fieldNotSpecifiedError("Password");
                }
                Connector pveConnector = new Connector(hostname, username, realm, password, ignoreSSL);
                pveConnector.login();
                return FormValidation.ok((String)"Login successful");
            }
            catch (LoginException e) {
                LOGGER.log(Level.SEVERE, "Authentication error", e);
                return FormValidation.error((String)"Authentication error. Please verify your login credentials or check logs.");
            }
        }
    }
}

