/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox.pve2api;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.login.LoginException;
import us.monoid.json.JSONArray;
import us.monoid.json.JSONException;
import us.monoid.json.JSONObject;
import us.monoid.web.AbstractContent;
import us.monoid.web.JSONResource;
import us.monoid.web.Resty;

public class Connector {
    public static final long WAIT_TIME_MS = 1000L;
    protected Integer port = 8006;
    protected String username;
    protected String realm;
    protected String password;
    protected String baseURL;
    private String authTicket;
    private Date authTicketIssuedTimestamp;
    private String csrfPreventionToken;
    private static SSLSocketFactory cachedSSLSocketFactory = null;
    private static HostnameVerifier cachedHostnameVerifier = null;

    private static void ignoreAllCerts() {
        if (cachedSSLSocketFactory == null) {
            cachedSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        }
        if (cachedHostnameVerifier == null) {
            cachedHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        }
        X509TrustManager trm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        HostnameVerifier hnv = new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{trm}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hnv);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static void resetCachedSSLHelperObjects() {
        if (cachedSSLSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(cachedSSLSocketFactory);
        }
        if (cachedHostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(cachedHostnameVerifier);
        }
    }

    public Connector(String hostname, String username, String realm, String password) {
        this(hostname, username, realm, password, false);
    }

    public Connector(String hostname, String username, String realm, String password, Boolean ignoreSSL) {
        try {
            URI uri = new URI("https://" + hostname);
            if (uri.getPort() != -1) {
                hostname = uri.getHost();
                this.port = uri.getPort();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.username = username;
        this.realm = realm;
        this.password = password;
        if (ignoreSSL.booleanValue()) {
            Connector.ignoreAllCerts();
        } else {
            Connector.resetCachedSSLHelperObjects();
        }
        this.authTicketIssuedTimestamp = null;
        this.baseURL = "https://" + hostname + ":" + this.port.toString() + "/api2/json/";
    }

    public void login() throws IOException, LoginException {
        Resty r = new Resty(new Resty.Option[0]);
        JSONResource authTickets = r.json(this.baseURL + "access/ticket", (AbstractContent)Resty.form((String)("username=" + this.username + "@" + this.realm + "&password=" + this.password)));
        try {
            this.authTicket = authTickets.get("data.ticket").toString();
            this.csrfPreventionToken = authTickets.get("data.CSRFPreventionToken").toString();
            this.authTicketIssuedTimestamp = new Date();
        }
        catch (Exception e) {
            throw new LoginException("Failed reading JSON response");
        }
    }

    public void checkIfAuthTicketIsValid() throws IOException, LoginException {
        if (this.authTicketIssuedTimestamp == null || this.authTicketIssuedTimestamp.getTime() <= new Date().getTime() - 0x6DDD00L) {
            this.login();
        }
    }

    private Resty authedClient() throws IOException, LoginException {
        this.checkIfAuthTicketIsValid();
        Resty r = new Resty(new Resty.Option[0]);
        r.withHeader("Cookie", "PVEAuthCookie=" + this.authTicket);
        r.withHeader("CSRFPreventionToken", this.csrfPreventionToken);
        return r;
    }

    private JSONResource getJSONResource(String resource) throws IOException, LoginException {
        return this.authedClient().json(this.baseURL + resource);
    }

    public List<String> getNodes() throws IOException, LoginException, JSONException {
        ArrayList<String> res = new ArrayList<String>();
        JSONArray nodes = this.getJSONResource("nodes").toObject().getJSONArray("data");
        for (int i = 0; i < nodes.length(); ++i) {
            res.add(nodes.getJSONObject(i).getString("node"));
        }
        return res;
    }

    public JSONObject getTaskStatus(String node, String taskId) throws IOException, LoginException, JSONException {
        JSONResource response = this.getJSONResource("nodes/" + node + "/tasks/" + taskId + "/status");
        return response.toObject().getJSONObject("data");
    }

    public JSONObject getQemuMachineStatus(String node, Integer vmid) throws IOException, LoginException, JSONException {
        JSONResource response = this.getJSONResource("nodes/" + node + "/qemu/" + vmid + "/status/current");
        return response.toObject().getJSONObject("data");
    }

    public Boolean isQemuMachineRunning(String node, Integer vmid) throws IOException, LoginException, JSONException {
        JSONObject QemuMachineStatus = null;
        Boolean isRunning = true;
        QemuMachineStatus = this.getQemuMachineStatus(node, vmid);
        isRunning = QemuMachineStatus.getString("status").equals("running");
        return isRunning;
    }

    public JSONObject waitForTaskToFinish(String node, String taskId) throws IOException, LoginException, JSONException, InterruptedException {
        JSONObject lastTaskStatus = null;
        Boolean isRunning = true;
        while (isRunning.booleanValue()) {
            lastTaskStatus = this.getTaskStatus(node, taskId);
            isRunning = lastTaskStatus.getString("status").equals("running");
            if (!isRunning.booleanValue()) continue;
            Thread.sleep(1000L);
        }
        return lastTaskStatus;
    }

    public HashMap<String, Integer> getQemuMachines(String node) throws IOException, LoginException, JSONException {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        JSONArray qemuVMs = this.getJSONResource("nodes/" + node + "/qemu").toObject().getJSONArray("data");
        for (int i = 0; i < qemuVMs.length(); ++i) {
            JSONObject vm = qemuVMs.getJSONObject(i);
            res.put(vm.getString("name"), vm.getInt("vmid"));
        }
        return res;
    }

    public List<String> getQemuMachineSnapshots(String node, Integer vmid) throws IOException, LoginException, JSONException {
        ArrayList<String> res = new ArrayList<String>();
        JSONArray snapshots = this.getJSONResource("nodes/" + node + "/qemu/" + vmid.toString() + "/snapshot").toObject().getJSONArray("data");
        for (int i = 0; i < snapshots.length(); ++i) {
            res.add(snapshots.getJSONObject(i).getString("name"));
        }
        return res;
    }

    public String rollbackQemuMachineSnapshot(String node, Integer vmid, String snapshotName) throws IOException, LoginException, JSONException {
        Resty r = this.authedClient();
        String resource = "nodes/" + node + "/qemu/" + vmid.toString() + "/snapshot/" + snapshotName + "/rollback";
        JSONResource response = r.json(this.baseURL + resource, (AbstractContent)Resty.form((String)""));
        return response.toObject().getString("data");
    }

    public String startQemuMachine(String node, Integer vmid) throws IOException, LoginException, JSONException {
        Resty r = this.authedClient();
        String resource = "nodes/" + node + "/qemu/" + vmid.toString() + "/status/start";
        JSONResource response = r.json(this.baseURL + resource, (AbstractContent)Resty.form((String)""));
        return response.toObject().getString("data");
    }

    public String stopQemuMachine(String node, Integer vmid) throws IOException, LoginException, JSONException {
        Resty r = this.authedClient();
        String resource = "nodes/" + node + "/qemu/" + vmid.toString() + "/status/stop";
        JSONResource response = r.json(this.baseURL + resource, (AbstractContent)Resty.form((String)""));
        return response.toObject().getString("data");
    }

    public String shutdownQemuMachine(String node, Integer vmid) throws IOException, LoginException, JSONException {
        Resty r = this.authedClient();
        String resource = "nodes/" + node + "/qemu/" + vmid.toString() + "/status/shutdown";
        JSONResource response = r.json(this.baseURL + resource, (AbstractContent)Resty.form((String)""));
        return response.toObject().getString("data");
    }
}

