/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox;

import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jenkinsci.plugins.proxmox.Messages;
import org.jenkinsci.plugins.proxmox.VirtualMachineLauncher;
import org.jenkinsci.plugins.proxmox.VirtualMachineSlave;
import org.jvnet.localizer.Localizable;

public class VirtualMachineSlaveComputer
extends SlaveComputer {
    private AtomicBoolean isRevertingSnapshot = new AtomicBoolean(false);

    public VirtualMachineSlaveComputer(Slave slave) {
        super(slave);
    }

    public void tryReconnect() {
        if (this.isRevertingSnapshot.get()) {
            this.getListener().getLogger().println("INFO: trying to reconnect while snapshot revert - ignoring");
            return;
        }
        super.tryReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskAccepted(Executor executor, Queue.Task task) {
        VirtualMachineSlave slave;
        VirtualMachineLauncher launcher;
        super.taskAccepted(executor, task);
        Slave node = this.getNode();
        if (node instanceof VirtualMachineSlave && (launcher = (VirtualMachineLauncher)(slave = (VirtualMachineSlave)node).getLauncher()).isLaunchSupported() && slave.getRevertPolicy() == VirtualMachineLauncher.RevertPolicy.BEFORE_JOB) {
            try {
                this.isRevertingSnapshot.set(true);
                Future disconnectFuture = this.disconnect(OfflineCause.create((Localizable)Messages._VirtualMachineSlaveComputer_disconnectBeforeSnapshotRevert()));
                disconnectFuture.get();
                this.getListener().getLogger().println("INFO: slave disconnected");
                launcher.revertSnapshot(this, this.getListener());
                this.getListener().getLogger().println("INFO: snapshot reverted");
                launcher.launch(this, this.getListener());
                this.getListener().getLogger().println("INFO: slave launched");
            }
            catch (IOException | InterruptedException e) {
                this.getListener().getLogger().println("ERROR: Snapshot revert failed: " + e.getMessage());
            }
            catch (ExecutionException e) {
                this.getListener().getLogger().println("ERROR: Exception while performing asynchronous disconnect: " + e.getMessage());
            }
            finally {
                this.isRevertingSnapshot.set(false);
            }
        }
    }

    protected Future<?> _connect(boolean forceReconnect) {
        return super._connect(forceReconnect);
    }
}

