/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.LoginException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.proxmox.Datacenter;
import org.jenkinsci.plugins.proxmox.VirtualMachineLauncher;
import org.jenkinsci.plugins.proxmox.VirtualMachineSlaveComputer;
import org.jenkinsci.plugins.proxmox.pve2api.Connector;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import us.monoid.json.JSONException;

public class VirtualMachineSlave
extends Slave {
    private static final long serialVersionUID = 1L;
    private String datacenterDescription;
    private String datacenterNode;
    private String snapshotName;
    private Integer virtualMachineId;
    private Boolean startVM;
    private int startupWaitingPeriodSeconds;
    private VirtualMachineLauncher.RevertPolicy revertPolicy;

    @DataBoundConstructor
    public VirtualMachineSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String datacenterDescription, String datacenterNode, Integer virtualMachineId, String snapshotName, Boolean startVM, int startupWaitingPeriodSeconds, VirtualMachineLauncher.RevertPolicy revertPolicy) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new VirtualMachineLauncher(delegateLauncher, datacenterDescription, datacenterNode, virtualMachineId, snapshotName, startVM, startupWaitingPeriodSeconds, revertPolicy), retentionStrategy, Optional.ofNullable(nodeProperties).orElse(Collections.emptyList()));
        this.datacenterDescription = datacenterDescription;
        this.datacenterNode = datacenterNode;
        this.virtualMachineId = virtualMachineId;
        this.snapshotName = snapshotName;
        this.startVM = startVM;
        this.startupWaitingPeriodSeconds = startupWaitingPeriodSeconds;
        this.revertPolicy = revertPolicy;
    }

    public String getDatacenterDescription() {
        return this.datacenterDescription;
    }

    public String getDatacenterNode() {
        return this.datacenterNode;
    }

    public Integer getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public Boolean getStartVM() {
        return this.startVM;
    }

    public int getStartupWaitingPeriodSeconds() {
        return this.startupWaitingPeriodSeconds;
    }

    public VirtualMachineLauncher.RevertPolicy getRevertPolicy() {
        return this.revertPolicy;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((VirtualMachineLauncher)this.getLauncher()).getLauncher();
    }

    public Computer createComputer() {
        return new VirtualMachineSlaveComputer(this);
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        private String datacenterDescription;
        private String datacenterNode;
        private Integer virtualMachineId;
        private String snapshotName;
        private Boolean startVM;
        private VirtualMachineLauncher.RevertPolicy revertPolicy;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual machine running on a Proxmox datacenter.";
        }

        public boolean isInstantiable() {
            return true;
        }

        public ListBoxModel doFillDatacenterDescriptionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("[Select]", "");
            for (Cloud cloud : Jenkins.get().clouds) {
                if (!(cloud instanceof Datacenter)) continue;
                items.add(((Datacenter)cloud).getHostname(), ((Datacenter)cloud).getDatacenterDescription());
            }
            return items;
        }

        public ListBoxModel doFillDatacenterNodeItems(@QueryParameter(value="datacenterDescription") String datacenterDescription) {
            ListBoxModel items = new ListBoxModel();
            items.add("[Select]", "");
            Datacenter datacenter = this.getDatacenterByDescription(datacenterDescription);
            if (datacenter != null) {
                for (String node : datacenter.getNodes()) {
                    items.add(node);
                }
            }
            return items;
        }

        public ListBoxModel doFillVirtualMachineIdItems(@QueryParameter(value="datacenterDescription") String datacenterDescription, @QueryParameter(value="datacenterNode") String datacenterNode) {
            ListBoxModel items = new ListBoxModel();
            items.add("[Select]", "");
            Datacenter datacenter = this.getDatacenterByDescription(datacenterDescription);
            if (datacenter != null) {
                HashMap<String, Integer> machines = datacenter.getQemuMachines(datacenterNode);
                for (Map.Entry<String, Integer> me : machines.entrySet()) {
                    items.add(me.getKey().toString(), me.getValue().toString());
                }
            }
            return items;
        }

        public ListBoxModel doFillSnapshotNameItems(@QueryParameter(value="datacenterDescription") String datacenterDescription, @QueryParameter(value="datacenterNode") String datacenterNode, @QueryParameter(value="virtualMachineId") String virtualMachineId) {
            ListBoxModel items = new ListBoxModel();
            items.add("[Select]", "");
            Datacenter datacenter = this.getDatacenterByDescription(datacenterDescription);
            if (datacenter != null && virtualMachineId != null && virtualMachineId.length() != 0) {
                for (String snapshot : datacenter.getQemuMachineSnapshots(datacenterNode, Integer.parseInt(virtualMachineId))) {
                    items.add(snapshot);
                }
            }
            return items;
        }

        public String getDatacenterDescription() {
            return this.datacenterDescription;
        }

        public String getDatecenterNode() {
            return this.datacenterNode;
        }

        public Integer getVirtualMachineId() {
            return this.virtualMachineId;
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        public Boolean getStartVM() {
            return this.startVM;
        }

        public VirtualMachineLauncher.RevertPolicy getRevertPolicy() {
            return this.revertPolicy;
        }

        public FormValidation doTestRollback(@QueryParameter String datacenterDescription, @QueryParameter String datacenterNode, @QueryParameter Integer virtualMachineId, @QueryParameter String snapshotName) {
            Datacenter datacenter = this.getDatacenterByDescription(datacenterDescription);
            if (datacenter == null) {
                return FormValidation.error((String)"Datacenter not found!");
            }
            Connector pveApi = datacenter.proxmoxInstance();
            try {
                String taskStatus = pveApi.rollbackQemuMachineSnapshot(datacenterNode, virtualMachineId, snapshotName);
                return FormValidation.ok((String)("Returned: " + taskStatus));
            }
            catch (IOException e) {
                return FormValidation.error((String)("IO: " + e.getMessage()));
            }
            catch (LoginException e) {
                return FormValidation.error((String)("Login Failed: " + e.getMessage()));
            }
            catch (JSONException e) {
                return FormValidation.error((String)("JSON: " + e.getMessage()));
            }
        }

        private Datacenter getDatacenterByDescription(String datacenterDescription) {
            if (datacenterDescription != null && !datacenterDescription.equals("")) {
                for (Cloud cloud : Jenkins.get().clouds) {
                    if (!(cloud instanceof Datacenter) || !((Datacenter)cloud).getDatacenterDescription().equals(datacenterDescription)) continue;
                    return (Datacenter)cloud;
                }
            }
            return null;
        }
    }
}

