/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox;

import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.proxmox.Datacenter;
import org.jenkinsci.plugins.proxmox.pve2api.Connector;
import org.kohsuke.stapler.DataBoundConstructor;
import us.monoid.json.JSONException;
import us.monoid.json.JSONObject;

public class VirtualMachineLauncher
extends DelegatingComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineLauncher.class.getName());
    @Deprecated
    private transient ComputerLauncher delegate;
    @Deprecated
    private transient int WAIT_TIME_MS;
    private String datacenterDescription;
    private String datacenterNode;
    private Integer virtualMachineId;
    private String snapshotName;
    private Boolean startVM;
    private int waitingTimeSecs;
    private final RevertPolicy revertPolicy;

    @DataBoundConstructor
    public VirtualMachineLauncher(ComputerLauncher launcher, String datacenterDescription, String datacenterNode, Integer virtualMachineId, String snapshotName, Boolean startVM, int waitingTimeSecs, RevertPolicy revertPolicy) {
        super(launcher);
        this.datacenterDescription = datacenterDescription;
        this.datacenterNode = datacenterNode;
        this.virtualMachineId = virtualMachineId;
        this.snapshotName = snapshotName;
        this.startVM = startVM;
        this.waitingTimeSecs = waitingTimeSecs;
        this.revertPolicy = revertPolicy;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.delegate != null) {
            return new VirtualMachineLauncher(this.delegate, this.datacenterDescription, this.datacenterNode, this.virtualMachineId, this.snapshotName, this.startVM, this.WAIT_TIME_MS / 1000, this.revertPolicy);
        }
        return this;
    }

    @Deprecated
    public ComputerLauncher getDelegate() {
        return this.launcher;
    }

    public Datacenter findDatacenterInstance() throws RuntimeException {
        if (this.datacenterDescription != null && this.virtualMachineId != null) {
            for (Cloud cloud : Jenkins.get().clouds) {
                if (!(cloud instanceof Datacenter) || !((Datacenter)cloud).getDatacenterDescription().equals(this.datacenterDescription)) continue;
                return (Datacenter)cloud;
            }
        }
        throw new RuntimeException("Could not find the proxmox datacenter instance!");
    }

    public boolean isLaunchSupported() {
        boolean overrideLaunchSupported = this.launcher.isLaunchSupported();
        if (this.launcher instanceof JNLPLauncher) {
            overrideLaunchSupported = true;
        }
        return overrideLaunchSupported;
    }

    public void startSlaveIfNeeded(TaskListener taskListener) throws IOException, InterruptedException {
        String taskId = null;
        JSONObject taskStatus = null;
        try {
            Datacenter datacenter = this.findDatacenterInstance();
            Connector pve = datacenter.proxmoxInstance();
            Boolean isvmIdRunning = pve.isQemuMachineRunning(this.datacenterNode, this.virtualMachineId);
            if (!isvmIdRunning.booleanValue()) {
                taskListener.getLogger().println("Starting virtual machine...");
                taskId = pve.startQemuMachine(this.datacenterNode, this.virtualMachineId);
                taskStatus = pve.waitForTaskToFinish(this.datacenterNode, taskId);
                taskListener.getLogger().println("Task finished! Status object: " + taskStatus.toString());
            }
        }
        catch (IOException e) {
            taskListener.getLogger().println("ERROR: IOException: " + e.getMessage());
        }
        catch (JSONException e) {
            taskListener.getLogger().println("ERROR: Parsing JSON: " + e.getMessage());
        }
        catch (LoginException e) {
            taskListener.getLogger().println("ERROR: Login failed: " + e.getMessage());
        }
    }

    public void revertSnapshot(SlaveComputer slaveComputer, TaskListener taskListener) throws InterruptedException {
        String taskId = null;
        JSONObject taskStatus = null;
        try {
            Datacenter datacenter = this.findDatacenterInstance();
            Connector pve = datacenter.proxmoxInstance();
            if (!this.snapshotName.equals("current")) {
                taskListener.getLogger().println("Virtual machine \"" + this.virtualMachineId + "\" (Name \"" + slaveComputer.getDisplayName() + "\") is being reverted...");
                taskId = pve.rollbackQemuMachineSnapshot(this.datacenterNode, this.virtualMachineId, this.snapshotName);
                taskListener.getLogger().println("Proxmox returned: " + taskId);
                taskStatus = pve.waitForTaskToFinish(this.datacenterNode, taskId);
                taskListener.getLogger().println("Task finished! Status object: " + taskStatus.toString());
            }
            if (this.startVM.booleanValue()) {
                this.startSlaveIfNeeded(taskListener);
            }
        }
        catch (IOException e) {
            taskListener.getLogger().println("ERROR: IOException: " + e.getMessage());
        }
        catch (JSONException e) {
            taskListener.getLogger().println("ERROR: Parsing JSON: " + e.getMessage());
        }
        catch (LoginException e) {
            taskListener.getLogger().println("ERROR: Login failed: " + e.getMessage());
        }
        if (!(this.launcher instanceof JNLPLauncher)) {
            Thread.sleep(this.waitingTimeSecs * 1000);
        }
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        if (this.revertPolicy == RevertPolicy.AFTER_CONNECT) {
            this.revertSnapshot(slaveComputer, taskListener);
        } else if (this.startVM.booleanValue()) {
            this.startSlaveIfNeeded(taskListener);
        }
        this.launcher.launch(slaveComputer, taskListener);
    }

    public void shutdown(SlaveComputer slaveComputer, TaskListener taskListener) {
        String taskId = null;
        JSONObject taskStatus = null;
        try {
            taskListener.getLogger().println("Virtual machine \"" + this.virtualMachineId + "\" (slave \"" + slaveComputer.getDisplayName() + "\") is being shutdown.");
            Datacenter datacenter = this.findDatacenterInstance();
            Connector pve = datacenter.proxmoxInstance();
            taskId = pve.shutdownQemuMachine(this.datacenterNode, this.virtualMachineId);
            taskStatus = pve.waitForTaskToFinish(this.datacenterNode, taskId);
            if (!taskStatus.getString("exitstatus").equals("OK")) {
                taskListener.getLogger().println("Virtual machine \"" + this.virtualMachineId + "\" (slave \"" + slaveComputer.getDisplayName() + "\") was not able to shutdown, doing a stop instead");
                taskId = pve.stopQemuMachine(this.datacenterNode, this.virtualMachineId);
                taskStatus = pve.waitForTaskToFinish(this.datacenterNode, taskId);
            }
            taskListener.getLogger().println("Task finished! Status object: " + taskStatus.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception: " + e.getMessage());
        }
        catch (JSONException e) {
            LOGGER.log(Level.SEVERE, "Parsing JSON: " + e.getMessage());
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Waiting for task completion failed: " + e.getMessage());
        }
        catch (LoginException e) {
            LOGGER.log(Level.WARNING, "Login failed: " + e.getMessage());
        }
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        if (this.revertPolicy == RevertPolicy.AFTER_CONNECT) {
            this.shutdown(slaveComputer, taskListener);
        }
        super.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    public static enum RevertPolicy {
        AFTER_CONNECT("After connect to the virtual machine"),
        BEFORE_JOB("Before every job executing on the virtual machine");

        private final String label;

        private RevertPolicy(String policy) {
            this.label = policy;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

