/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.proxmox;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.proxmox.pve2api.Connector;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import us.monoid.json.JSONException;

public class Datacenter
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(Datacenter.class.getName());
    private final String hostname;
    private final String username;
    private final String realm;
    private final String password;
    private final Boolean ignoreSSL;
    private transient Connector pveConnector;

    @DataBoundConstructor
    public Datacenter(String hostname, String username, String realm, String password, Boolean ignoreSSL) {
        super("Datacenter(proxmox)");
        this.hostname = hostname;
        this.username = username;
        this.realm = realm;
        this.password = password;
        this.ignoreSSL = ignoreSSL;
        this.pveConnector = null;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getIgnoreSSL() {
        return this.ignoreSSL;
    }

    public String getDatacenterDescription() {
        return this.username + "@" + this.realm + " - " + this.hostname;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public Connector proxmoxInstance() {
        if (this.pveConnector == null) {
            this.pveConnector = new Connector(this.hostname, this.username, this.realm, this.password, this.ignoreSSL);
        }
        return this.pveConnector;
    }

    public List<String> getNodes() {
        Connector pveConnector = this.proxmoxInstance();
        try {
            return pveConnector.getNodes();
        }
        catch (JSONException e) {
            return new ArrayList<String>();
        }
        catch (LoginException e) {
            return new ArrayList<String>();
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    public HashMap<String, Integer> getQemuMachines(String node) {
        Connector pveConnector = this.proxmoxInstance();
        try {
            return pveConnector.getQemuMachines(node);
        }
        catch (JSONException e) {
            return new HashMap<String, Integer>();
        }
        catch (LoginException e) {
            return new HashMap<String, Integer>();
        }
        catch (IOException e) {
            return new HashMap<String, Integer>();
        }
    }

    public List<String> getQemuMachineSnapshots(String node, Integer vmid) {
        Connector pveConnector = this.proxmoxInstance();
        try {
            return pveConnector.getQemuMachineSnapshots(node, vmid);
        }
        catch (JSONException e) {
            return new ArrayList<String>();
        }
        catch (LoginException e) {
            return new ArrayList<String>();
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Proxmox Datacenter";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.save();
            return super.configure(req, o);
        }

        private FormValidation fieldNotSpecifiedError(String fieldName) {
            return FormValidation.error((String)(fieldName + " not specified"));
        }

        private FormValidation emptyStringValidation(String fieldName, String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return this.fieldNotSpecifiedError(fieldName);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHostname(@QueryParameter String value) {
            return this.emptyStringValidation("Hostname", value);
        }

        public FormValidation doCheckUsername(@QueryParameter String value) {
            return this.emptyStringValidation("Username", value);
        }

        public FormValidation doCheckRealm(@QueryParameter String value) {
            return this.emptyStringValidation("Realm", value);
        }

        public FormValidation doCheckPassword(@QueryParameter String value) {
            return this.emptyStringValidation("Password", value);
        }

        public FormValidation doTestConnection(@QueryParameter String hostname, @QueryParameter String username, @QueryParameter String realm, @QueryParameter String password, @QueryParameter Boolean ignoreSSL) {
            try {
                if (hostname.isEmpty()) {
                    return this.fieldNotSpecifiedError("Hostname");
                }
                if (username.isEmpty()) {
                    return this.fieldNotSpecifiedError("Username");
                }
                if (realm.isEmpty()) {
                    return this.fieldNotSpecifiedError("Realm");
                }
                if (password.isEmpty()) {
                    return this.fieldNotSpecifiedError("Password");
                }
                Connector pveConnector = new Connector(hostname, username, realm, password, ignoreSSL);
                pveConnector.login();
                return FormValidation.ok((String)"Login successful");
            }
            catch (LoginException e) {
                return FormValidation.error((String)"Invalid login credentials");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error: " + e.getMessage());
                return FormValidation.error((String)("Error: " + e.getMessage()));
            }
        }
    }
}

