/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.integrations.jobdsl;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import hudson.plugins.promoted_builds.integrations.jobdsl.PromotionContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslEnvironment;

public class PromotionsContext
implements Context {
    private final DslEnvironment dslEnvironment;
    Set<String> names = new HashSet<String>();
    Map<String, PromotionContext> promotionContexts = new HashMap<String, PromotionContext>();

    public PromotionsContext(DslEnvironment dslEnvironment) {
        this.dslEnvironment = dslEnvironment;
    }

    public void promotion(Closure<?> promotionClosure) {
        PromotionContext promotionContext = new PromotionContext(this.dslEnvironment);
        ContextExtensionPoint.executeInContext(promotionClosure, (Context)promotionContext);
        Preconditions.checkNotNull((Object)promotionContext.getName(), (Object)"promotion name cannot be null");
        Preconditions.checkArgument((promotionContext.getName().length() > 0 ? 1 : 0) != 0);
        this.names.add(promotionContext.getName());
        this.promotionContexts.put(promotionContext.getName(), promotionContext);
    }
}

