/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.promoted_builds.Messages;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.Status;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class LastBuildPromotionStatusColumn
extends ListViewColumn {
    @DataBoundConstructor
    public LastBuildPromotionStatusColumn() {
    }

    public List<String> getPromotionIcons(Item item) {
        ArrayList<String> icons = new ArrayList<String>();
        if (item instanceof Job) {
            PromotedBuildAction a;
            Job job = (Job)item;
            Run b = job.getLastBuild();
            PromotedBuildAction promotedBuildAction = a = b != null ? (PromotedBuildAction)b.getAction(PromotedBuildAction.class) : null;
            if (a != null) {
                for (Status s : a.getPromotions()) {
                    PromotionProcess process = s.getProcess();
                    if (process == null || !process.isVisible()) continue;
                    icons.add(s.getIcon("16px"));
                }
            }
        }
        return icons;
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.LastBuildPromotionStatusColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

