/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class CopyListener
extends ItemListener {
    public void onCopied(Item src, Item item) {
        File[] subdirs;
        JobPropertyImpl prop;
        if (src instanceof Job && (prop = (JobPropertyImpl)((Job)src).getProperty(JobPropertyImpl.class)) != null && (subdirs = prop.getRootDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        })) != null) {
            prop = (JobPropertyImpl)((Job)item).getProperty(JobPropertyImpl.class);
            for (File subdir : subdirs) {
                try {
                    Files.copy(new File(subdir, "config.xml").toPath(), new File(prop.getRootDirFor(subdir.getName()), "config.xml").toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException | InvalidPathException e) {
                    Logger.getLogger(CopyListener.class.getName()).log(Level.WARNING, "Failed to copy/load promotion " + subdir + " into new job", e);
                }
            }
            prop.setOwner(prop.getOwner());
        }
    }
}

