/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.console.HyperlinkNote;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.promoted_builds.Messages;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import java.util.Objects;

public class PromotionCause
extends Cause.UpstreamCause {
    private String promotionProcessName;
    private String promotionBuildUrl;
    private int promotionBuildNumber;

    PromotionCause(Promotion promotion, Run promotedBuild) {
        super(promotedBuild);
        this.promotionProcessName = ((PromotionProcess)promotion.getParent()).getName();
        this.promotionBuildUrl = promotion.getUrl();
        this.promotionBuildNumber = promotion.getNumber();
    }

    public String getShortDescription() {
        return Messages.PromotionCause_ShortDescription(this.promotionProcessName + " #" + this.promotionBuildNumber, this.getUpstreamProject(), Integer.toString(this.getUpstreamBuild()));
    }

    public void print(TaskListener listener) {
        listener.getLogger().println(Messages.PromotionCause_ShortDescription(HyperlinkNote.encodeTo((String)('/' + this.promotionBuildUrl), (String)(this.promotionProcessName + " #" + this.promotionBuildNumber)), HyperlinkNote.encodeTo((String)('/' + this.getUpstreamUrl()), (String)this.getUpstreamProject()), HyperlinkNote.encodeTo((String)('/' + this.getUpstreamUrl() + this.getUpstreamBuild()), (String)Integer.toString(this.getUpstreamBuild()))));
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + super.hashCode();
        hash = 53 * hash + (this.promotionProcessName != null ? this.promotionProcessName.hashCode() : 0);
        hash = 53 * hash + (this.promotionBuildUrl != null ? this.promotionBuildUrl.hashCode() : 0);
        hash = 53 * hash + this.promotionBuildNumber;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PromotionCause other = (PromotionCause)((Object)obj);
        if (!Objects.equals(this.promotionProcessName, other.promotionProcessName)) {
            return false;
        }
        if (!Objects.equals(this.promotionBuildUrl, other.promotionBuildUrl)) {
            return false;
        }
        return this.promotionBuildNumber == other.promotionBuildNumber;
    }
}

