/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.RestrictedSince;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.Cause;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.ManualPromotionBadge;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionPermissionHelper;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.Status;
import hudson.plugins.promoted_builds.conditions.ManualCondition;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class PromotedBuildAction
implements BuildBadgeAction {
    public final AbstractBuild<?, ?> owner;
    private final CopyOnWriteList<Status> statuses = new CopyOnWriteList();

    public PromotedBuildAction(AbstractBuild<?, ?> owner) {
        assert (owner != null);
        this.owner = owner;
    }

    public PromotedBuildAction(AbstractBuild<?, ?> owner, Status firstStatus) {
        this(owner);
        this.statuses.add((Object)firstStatus);
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public AbstractProject<?, ?> getProject() {
        return this.owner.getProject();
    }

    public boolean contains(PromotionProcess process) {
        for (Status s : this.statuses) {
            if (!s.isFor(process)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name) {
        for (Status s : this.statuses) {
            if (!s.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean add(Status status) throws IOException {
        for (Status s : this.statuses) {
            if (!s.name.equals(status.name)) continue;
            return false;
        }
        this.statuses.add((Object)status);
        status.parent = this;
        this.owner.save();
        return true;
    }

    @Exported
    public List<Status> getPromotions() {
        return this.statuses.getView();
    }

    public List<Promotion> getPromotionBuilds(PromotionProcess promotionProcess) {
        ArrayList<Promotion> filtered = new ArrayList<Promotion>();
        for (Status s : this.getPromotions()) {
            if (!s.isFor(promotionProcess)) continue;
            filtered.addAll(s.getPromotionBuilds());
        }
        return filtered;
    }

    @CheckForNull
    public Status getPromotion(String name) {
        for (Status s : this.statuses) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        return null;
    }

    public boolean hasPromotion() {
        return !this.statuses.isEmpty();
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.0")
    public boolean canPromote() {
        return this.getProject().hasPermission(Promotion.PROMOTE);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean canPromote(String processName) {
        PromotionProcess process = this.getPromotionProcess(processName);
        ManualCondition manualCondition = null;
        if (process != null) {
            manualCondition = (ManualCondition)process.getPromotionCondition(ManualCondition.class.getName());
        }
        return PromotionPermissionHelper.hasPermission(this.getProject(), manualCondition);
    }

    public List<PromotionProcess> getPendingPromotions() {
        JobPropertyImpl pp = (JobPropertyImpl)this.getProject().getProperty(JobPropertyImpl.class);
        if (pp == null) {
            return Collections.emptyList();
        }
        ArrayList<PromotionProcess> r = new ArrayList<PromotionProcess>();
        for (PromotionProcess p : pp.getActiveItems()) {
            if (this.contains(p)) continue;
            r.add(p);
        }
        return r;
    }

    @CheckForNull
    public PromotionProcess getPromotionProcess(String name) {
        JobPropertyImpl pp = (JobPropertyImpl)this.getProject().getProperty(JobPropertyImpl.class);
        if (pp == null) {
            return null;
        }
        for (PromotionProcess p : pp.getItems()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public String getIconFileName() {
        return "star.png";
    }

    public String getDisplayName() {
        return "Promotion Status";
    }

    public String getUrlName() {
        return "promotion";
    }

    private Object readResolve() {
        for (Status s : this.statuses) {
            s.parent = this;
        }
        return this;
    }

    public Status getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        return this.getPromotion(name);
    }

    public HttpResponse doForcePromotion(@QueryParameter(value="name") String name) throws IOException {
        JobPropertyImpl pp = (JobPropertyImpl)this.getProject().getProperty(JobPropertyImpl.class);
        if (pp == null) {
            throw new IllegalStateException("This project doesn't have any promotion criteria set");
        }
        PromotionProcess p = pp.getItem(name);
        if (p == null) {
            throw new IllegalStateException("This project doesn't have the promotion criterion called " + name);
        }
        ManualCondition manualCondition = (ManualCondition)p.getPromotionCondition(ManualCondition.class.getName());
        PromotionPermissionHelper.checkPermission(this.getProject(), manualCondition);
        p.promote(this.owner, (Cause)new Cause.UserCause(), new ManualPromotionBadge());
        return HttpResponses.redirectToDot();
    }
}

