/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.integrations.jobdsl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Items;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.integrations.jobdsl.JobDslManualCondition;
import hudson.plugins.promoted_builds.integrations.jobdsl.JobDslPromotionProcess;
import hudson.plugins.promoted_builds.integrations.jobdsl.JobDslPromotionProcessConverter;
import hudson.plugins.promoted_builds.integrations.jobdsl.ManualConditionConverter;
import hudson.plugins.promoted_builds.integrations.jobdsl.PromotionContext;
import hudson.plugins.promoted_builds.integrations.jobdsl.PromotionsContext;
import hudson.plugins.promoted_builds.integrations.jobdsl.ReleasePromotionCondition;
import hudson.util.IOUtils;
import hudson.util.XStream2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.properties.PropertiesContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslEnvironment;
import javaposse.jobdsl.plugin.DslExtensionMethod;

@Extension(optional=true)
public class PromotionsExtensionPoint
extends ContextExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(PromotionsExtensionPoint.class.getName());
    private static final XStream XSTREAM = new XStream2();

    @DslExtensionMethod(context=PropertiesContext.class)
    public Object promotions(Runnable closure, DslEnvironment dslEnvironment) throws Descriptor.FormException, IOException {
        PromotionsContext context = new PromotionsContext(dslEnvironment);
        PromotionsExtensionPoint.executeInContext((Runnable)closure, (Context)context);
        dslEnvironment.put((Object)"processNames", context.names);
        JobPropertyImpl jobProperty = new JobPropertyImpl(context.names);
        HashMap<String, JobDslPromotionProcess> promotionProcesses = new HashMap<String, JobDslPromotionProcess>();
        for (String processName : context.names) {
            PromotionContext promotionContext = context.promotionContexts.get(processName);
            JobDslPromotionProcess jobDslPromotionProcess = new JobDslPromotionProcess();
            jobDslPromotionProcess.setName(processName);
            jobDslPromotionProcess.setIcon(promotionContext.getIcon());
            jobDslPromotionProcess.setAssignedLabel(promotionContext.getRestrict());
            jobDslPromotionProcess.setBuildSteps(promotionContext.getActions());
            jobDslPromotionProcess.setConditions(promotionContext.getConditions());
            jobDslPromotionProcess.setBuildWrappers(promotionContext.getWrappers());
            promotionProcesses.put(processName, jobDslPromotionProcess);
        }
        dslEnvironment.put((Object)"promotionProcesses", promotionProcesses);
        return jobProperty;
    }

    public void notifyItemCreated(Item item, DslEnvironment dslEnvironment) {
        this.notifyItemCreated(item, dslEnvironment, false);
    }

    public void notifyItemCreated(Item item, DslEnvironment dslEnvironment, boolean update) {
        LOGGER.log(Level.INFO, String.format("Creating promotions for %s", item.getName()));
        Map promotionProcesses = (Map)dslEnvironment.get((Object)"promotionProcesses");
        Set names = (Set)dslEnvironment.get((Object)"processNames");
        if (names != null && names.size() > 0) {
            for (String name : names) {
                JobDslPromotionProcess promotionProcess = (JobDslPromotionProcess)promotionProcesses.get(name);
                XSTREAM.registerConverter((Converter)new JobDslPromotionProcessConverter(XSTREAM.getMapper(), XSTREAM.getReflectionProvider()));
                XSTREAM.registerConverter((Converter)new ManualConditionConverter(XSTREAM.getMapper(), XSTREAM.getReflectionProvider()));
                XSTREAM.processAnnotations(new Class[]{JobDslPromotionProcess.class, JobDslManualCondition.class, ReleasePromotionCondition.class});
                String xml = XSTREAM.toXML((Object)promotionProcess);
                File dir = new File(item.getRootDir(), "promotions/" + name);
                File configXml = Items.getConfigFile((File)dir).getFile();
                boolean created = configXml.getParentFile().mkdirs();
                String createUpdate = created ? "Added" : "Updated";
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                    IOUtils.copy((InputStream)in, (File)configXml);
                    LOGGER.log(Level.INFO, String.format(createUpdate + " promotion with name %s for %s", name, item.getName()));
                    update = true;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error handling extension code", e);
                }
            }
        }
        if (update) {
            try {
                LOGGER.log(Level.INFO, String.format("Reloading config for %s", item.getName()));
                ((AbstractItem)item).doReload();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to cast item to AbstractItem and reload config", e);
            }
        }
    }

    public void notifyItemUpdated(Item item, DslEnvironment dslEnvironment) {
        File[] files;
        LOGGER.log(Level.INFO, String.format("Updating promotions for %s", item.getName()));
        Set newPromotions = (Set)dslEnvironment.get((Object)"processNames");
        File dir = new File(item.getRootDir(), "promotions/");
        boolean update = false;
        if (newPromotions != null && (files = dir.listFiles()) != null) {
            for (File promotion : files) {
                boolean deleted;
                if (newPromotions.contains(promotion.getName()) || !(deleted = promotion.delete())) continue;
                LOGGER.log(Level.INFO, String.format("Deleted promotion with name %s for %s", promotion.getName(), item.getName()));
                update = true;
            }
        }
        this.notifyItemCreated(item, dslEnvironment, update);
    }
}

