// CHECKSTYLE:OFF

package hudson.plugins.promoted_builds.conditions;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ManualCondition.DisplayName}: {@code Only when manually

     * approved}.
     * 
     * @return
     *     {@code Only when manually approved}
     */
    public static String ManualCondition_DisplayName() {
        return holder.format("ManualCondition.DisplayName");
    }

    /**
     * Key {@code ManualCondition.DisplayName}: {@code Only when manually

     * approved}.
     * 
     * @return
     *     {@code Only when manually approved}
     */
    public static Localizable _ManualCondition_DisplayName() {
        return new Localizable(holder, "ManualCondition.DisplayName");
    }

    /**
     * Key {@code UpstreamPromotionCondition.DisplayName}: {@code When the

     * following upstream promotions are promoted}.
     * 
     * @return
     *     {@code When the following upstream promotions are promoted}
     */
    public static String UpstreamPromotionCondition_DisplayName() {
        return holder.format("UpstreamPromotionCondition.DisplayName");
    }

    /**
     * Key {@code UpstreamPromotionCondition.DisplayName}: {@code When the

     * following upstream promotions are promoted}.
     * 
     * @return
     *     {@code When the following upstream promotions are promoted}
     */
    public static Localizable _UpstreamPromotionCondition_DisplayName() {
        return new Localizable(holder, "UpstreamPromotionCondition.DisplayName");
    }

    /**
     * Key {@code SelfPromotionCondition.DisplayName}: {@code Promote

     * immediately once the build is complete}.
     * 
     * @return
     *     {@code Promote immediately once the build is complete}
     */
    public static String SelfPromotionCondition_DisplayName() {
        return holder.format("SelfPromotionCondition.DisplayName");
    }

    /**
     * Key {@code SelfPromotionCondition.DisplayName}: {@code Promote

     * immediately once the build is complete}.
     * 
     * @return
     *     {@code Promote immediately once the build is complete}
     */
    public static Localizable _SelfPromotionCondition_DisplayName() {
        return new Localizable(holder, "SelfPromotionCondition.DisplayName");
    }

    /**
     * Key {@code GroovyCondition.MetQualificationLabel}: {@code Custom

     * Groovy script condition}.
     * 
     * @return
     *     {@code Custom Groovy script condition}
     */
    public static String GroovyCondition_MetQualificationLabel() {
        return holder.format("GroovyCondition.MetQualificationLabel");
    }

    /**
     * Key {@code GroovyCondition.MetQualificationLabel}: {@code Custom

     * Groovy script condition}.
     * 
     * @return
     *     {@code Custom Groovy script condition}
     */
    public static Localizable _GroovyCondition_MetQualificationLabel() {
        return new Localizable(holder, "GroovyCondition.MetQualificationLabel");
    }

    /**
     * Key {@code GroovyCondition.DisplayName}: {@code Custom Groovy script}.
     * 
     * @return
     *     {@code Custom Groovy script}
     */
    public static String GroovyCondition_DisplayName() {
        return holder.format("GroovyCondition.DisplayName");
    }

    /**
     * Key {@code GroovyCondition.DisplayName}: {@code Custom Groovy script}.
     * 
     * @return
     *     {@code Custom Groovy script}
     */
    public static Localizable _GroovyCondition_DisplayName() {
        return new Localizable(holder, "GroovyCondition.DisplayName");
    }

    /**
     * Key {@code DownstreamPassCondition.DisplayName}: {@code When the

     * following downstream projects build successfully}.
     * 
     * @return
     *     {@code When the following downstream projects build successfully}
     */
    public static String DownstreamPassCondition_DisplayName() {
        return holder.format("DownstreamPassCondition.DisplayName");
    }

    /**
     * Key {@code DownstreamPassCondition.DisplayName}: {@code When the

     * following downstream projects build successfully}.
     * 
     * @return
     *     {@code When the following downstream projects build successfully}
     */
    public static Localizable _DownstreamPassCondition_DisplayName() {
        return new Localizable(holder, "DownstreamPassCondition.DisplayName");
    }

    /**
     * Key {@code GroovyCondition.UnmetQualificationLabel}: {@code Custom

     * Groovy script condition}.
     * 
     * @return
     *     {@code Custom Groovy script condition}
     */
    public static String GroovyCondition_UnmetQualificationLabel() {
        return holder.format("GroovyCondition.UnmetQualificationLabel");
    }

    /**
     * Key {@code GroovyCondition.UnmetQualificationLabel}: {@code Custom

     * Groovy script condition}.
     * 
     * @return
     *     {@code Custom Groovy script condition}
     */
    public static Localizable _GroovyCondition_UnmetQualificationLabel() {
        return new Localizable(holder, "GroovyCondition.UnmetQualificationLabel");
    }

    /**
     * Key {@code ParameterizedSelfPromotionCondition.DisplayName}: {@code

     * Promote immediately once the build is complete based on build

     * parameters}.
     * 
     * @return
     *     {@code Promote immediately once the build is complete based on build

     *     parameters}
     */
    public static String ParameterizedSelfPromotionCondition_DisplayName() {
        return holder.format("ParameterizedSelfPromotionCondition.DisplayName");
    }

    /**
     * Key {@code ParameterizedSelfPromotionCondition.DisplayName}: {@code

     * Promote immediately once the build is complete based on build

     * parameters}.
     * 
     * @return
     *     {@code Promote immediately once the build is complete based on build

     *     parameters}
     */
    public static Localizable _ParameterizedSelfPromotionCondition_DisplayName() {
        return new Localizable(holder, "ParameterizedSelfPromotionCondition.DisplayName");
    }

}
