/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.Messages;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PromotionTrigger
extends Trigger<AbstractProject> {
    private final String jobName;
    private final String process;

    @DataBoundConstructor
    public PromotionTrigger(String jobName, String process) {
        this.jobName = jobName;
        this.process = process;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getProcess() {
        return this.process;
    }

    public boolean appliesTo(PromotionProcess proc) {
        return proc.getName().equals(this.process) && proc.getParent().getOwner().getFullName().equals(this.jobName);
    }

    public void consider(Promotion p) {
        if (this.appliesTo((PromotionProcess)p.getParent()) && this.job != null) {
            ((AbstractProject)this.job).scheduleBuild2(((AbstractProject)this.job).getQuietPeriod());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return "Build when another project is promoted";
        }

        public FormValidation doCheckJobName(@AncestorInPath Item project, @QueryParameter String value) {
            AbstractProject p;
            if (!project.hasPermission(Item.CONFIGURE) && project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            project.checkPermission(Item.CONFIGURE);
            if (StringUtils.isNotBlank((String)value) && (p = (AbstractProject)Jenkins.get().getItem(value, project, AbstractProject.class)) == null) {
                AbstractProject nearest = AbstractProject.findNearest((String)value, (ItemGroup)project.getParent());
                return FormValidation.error((String)(nearest != null ? Messages.BuildTrigger_NoSuchProject(value, nearest.getRelativeNameFrom(project)) : Messages.Shared_noSuchProject(value)));
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteJobName(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            List jobs = Jenkins.get().getItems(AbstractProject.class);
            for (AbstractProject job : jobs) {
                if (!job.getFullName().startsWith(value) || !job.hasPermission(Item.READ)) continue;
                candidates.add(job.getFullName());
            }
            return candidates;
        }

        public ListBoxModel doFillProcessItems(@AncestorInPath Item defaultJob, @QueryParameter(value="jobName") String jobName) {
            JobPropertyImpl pp;
            if (!defaultJob.hasPermission(Item.CONFIGURE) && defaultJob.hasPermission(Item.EXTENDED_READ)) {
                return new ListBoxModel();
            }
            defaultJob.checkPermission(Item.CONFIGURE);
            AbstractProject j = null;
            if (jobName != null) {
                j = (AbstractProject)Jenkins.get().getItem(jobName, defaultJob, AbstractProject.class);
            }
            ListBoxModel r = new ListBoxModel();
            if (j != null && (pp = (JobPropertyImpl)j.getProperty(JobPropertyImpl.class)) != null) {
                for (PromotionProcess proc : pp.getActiveItems()) {
                    r.add((Object)new ListBoxModel.Option(proc.getDisplayName(), proc.getName()));
                }
            }
            return r;
        }
    }
}

