/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractProject;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.conditions.ManualCondition;
import hudson.security.AccessDeniedException2;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PromotionPermissionHelper {
    public static void checkPermission(@Nonnull AbstractProject<?, ?> target, @CheckForNull ManualCondition associatedCondition) {
        if (!PromotionPermissionHelper.hasPermission(target, associatedCondition)) {
            throw new AccessDeniedException2(Jenkins.getAuthentication(), Promotion.PROMOTE);
        }
    }

    public static boolean hasPermission(@Nonnull AbstractProject<?, ?> target, @CheckForNull ManualCondition associatedCondition) {
        if (associatedCondition == null) {
            return target.hasPermission(Promotion.PROMOTE);
        }
        if (associatedCondition.getUsersAsSet().isEmpty()) {
            return target.hasPermission(Promotion.PROMOTE);
        }
        if (associatedCondition.isInUsersList() || associatedCondition.isInGroupList()) {
            return true;
        }
        return target.hasPermission(Jenkins.ADMINISTER);
    }
}

