/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.integrations.jobdsl;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import groovy.util.Node;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.integrations.jobdsl.JobDslPromotionProcess;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ObjectUtils;

public class JobDslPromotionProcessConverter
extends ReflectionConverter {
    private String classOwnership;
    private PluginManager pm;

    public JobDslPromotionProcessConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(JobDslPromotionProcess.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        JobDslPromotionProcess promotionProcess = (JobDslPromotionProcess)source;
        String plugin = this.obtainClassOwnership();
        if (plugin != null) {
            writer.addAttribute("plugin", plugin);
        }
        if (promotionProcess != null) {
            String assignedLabel;
            if (promotionProcess.getName() != null) {
                writer.startNode("name");
                writer.setValue(promotionProcess.getName());
                writer.endNode();
            }
            if (promotionProcess.getIcon() != null) {
                writer.startNode("icon");
                writer.setValue(promotionProcess.getIcon());
                writer.endNode();
            }
            if (promotionProcess.getAssignedLabel() != null && (assignedLabel = promotionProcess.getAssignedLabel()) != null) {
                writer.startNode("assignedLabel");
                writer.setValue(assignedLabel);
                writer.endNode();
            }
            if (promotionProcess.getConditions() != null) {
                writer.startNode("conditions");
                context.convertAnother(promotionProcess.getConditions());
                writer.endNode();
            }
            if (promotionProcess.getBuildSteps() != null) {
                writer.startNode("buildSteps");
                this.writeNodes(writer, promotionProcess.getBuildSteps());
                writer.endNode();
            }
            if (promotionProcess.getBuildWrappers() != null) {
                writer.startNode("buildWrappers");
                this.writeNodes(writer, promotionProcess.getBuildWrappers());
                writer.endNode();
            }
        }
    }

    private void writeNodes(HierarchicalStreamWriter writer, List<Node> nodes) {
        for (Node node : nodes) {
            writer.startNode(node.name().toString());
            if (node.value() instanceof Collection) {
                for (Object subNode : (Collection)node.value()) {
                    this.convertNode((Node)subNode, writer);
                }
            } else {
                writer.setValue(node.value().toString());
            }
            writer.endNode();
        }
    }

    private void convertNode(Node node, HierarchicalStreamWriter writer) {
        writer.startNode(node.name().toString());
        this.writeNodeAttributes(node, writer);
        if (node.value() instanceof Collection) {
            for (Object subNode : (Collection)node.value()) {
                this.convertNode((Node)subNode, writer);
            }
        } else {
            writer.setValue(node.value().toString());
        }
        writer.endNode();
    }

    private void writeNodeAttributes(Node node, HierarchicalStreamWriter writer) {
        Map attributes = node.attributes();
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String key = ObjectUtils.toString(entry.getKey());
                String value = ObjectUtils.toString(entry.getValue());
                writer.addAttribute(key, value);
            }
        }
    }

    @CheckForNull
    private String obtainClassOwnership() {
        if (this.classOwnership != null) {
            return this.classOwnership;
        }
        if (this.pm == null) {
            Jenkins j = Jenkins.getInstanceOrNull();
            PluginManager pluginManager = this.pm = j != null ? j.getPluginManager() : null;
        }
        if (this.pm == null) {
            return null;
        }
        PluginWrapper p = this.pm.whichPlugin(PromotionProcess.class);
        this.classOwnership = p != null ? p.getShortName() + '@' + JobDslPromotionProcessConverter.trimVersion(p.getVersion()) : null;
        return this.classOwnership;
    }

    static String trimVersion(String version) {
        return version.replaceFirst(" .+$", "");
    }
}

