/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.inheritance;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.JobProperty;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.inheritance.InheritanceSelector;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension(optional=true)
public class JobPropertyImplSelector
extends InheritanceSelector<JobProperty<?>> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(JobPropertyImplSelector.class.getName());

    public boolean isApplicableFor(Class<?> clazz) {
        return JobProperty.class.isAssignableFrom(clazz);
    }

    public InheritanceSelector.MODE getModeFor(Class<?> clazz) {
        if (JobPropertyImpl.class.isAssignableFrom(clazz)) {
            return InheritanceSelector.MODE.USE_LAST;
        }
        return InheritanceSelector.MODE.NOT_RESPONSIBLE;
    }

    public String getObjectIdentifier(JobProperty<?> obj) {
        if (obj != null && JobPropertyImpl.class.getName().equals(obj.getClass().getName())) {
            return JobPropertyImplSelector.class.getName();
        }
        return null;
    }

    public JobPropertyImpl merge(JobProperty<?> prior, JobProperty<?> latter, InheritanceProject caller) {
        return null;
    }

    public JobProperty<?> handleSingleton(JobProperty<?> jobProperty, InheritanceProject caller) {
        if (jobProperty == null || caller == null) {
            return jobProperty;
        }
        if (caller.isAbstract) {
            return jobProperty;
        }
        if (!JobPropertyImpl.class.isAssignableFrom(jobProperty.getClass())) {
            return jobProperty;
        }
        JobPropertyImpl jobPropertyImpl = (JobPropertyImpl)jobProperty;
        try {
            JobPropertyImpl newJobProperty = new JobPropertyImpl(jobPropertyImpl, (AbstractProject<?, ?>)caller);
            return newJobProperty;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error during hacking up JobPropertyImpl", ex);
            return jobProperty;
        }
    }
}

