/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.Status;
import hudson.plugins.promoted_builds.conditions.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class UpstreamPromotionCondition
extends PromotionCondition {
    private final String requiredPromotionNames;

    public UpstreamPromotionCondition(String requiredPromotionNames) {
        this.requiredPromotionNames = requiredPromotionNames;
    }

    public String getRequiredPromotionNames() {
        return this.requiredPromotionNames;
    }

    public Set<String> getRequiredPromotionNamesAsSet() {
        if (this.requiredPromotionNames == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.requiredPromotionNames.split(",")));
    }

    @Override
    public PromotionBadge isMet(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        Badge badge = new Badge();
        Set<String> requiredPromotions = this.getRequiredPromotionNamesAsSet();
        if (requiredPromotions.isEmpty()) {
            return badge;
        }
        PromotedBuildAction pba = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
        if (pba == null) {
            return null;
        }
        for (Status status : pba.getPromotions()) {
            if (!status.isPromotionSuccessful()) continue;
            requiredPromotions.remove(status.getName());
            badge.add(status.getName());
            if (!requiredPromotions.isEmpty()) continue;
            break;
        }
        return requiredPromotions.isEmpty() ? badge : null;
    }

    @Extension
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.UpstreamPromotionCondition_DisplayName();
        }

        public PromotionCondition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new UpstreamPromotionCondition(formData.getString("promotions"));
        }
    }

    public static final class Badge
    extends PromotionBadge {
        @Exported
        public final List<String> promotions = new ArrayList<String>(3);

        public void add(String promotion) {
            this.promotions.add(promotion);
        }
    }
}

