/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.conditions.Messages;
import hudson.plugins.promoted_builds.conditions.SelfPromotionBadge;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SelfPromotionCondition
extends PromotionCondition {
    private final boolean evenIfUnstable;

    @DataBoundConstructor
    public SelfPromotionCondition(boolean evenIfUnstable) {
        this.evenIfUnstable = evenIfUnstable;
    }

    public boolean isEvenIfUnstable() {
        return this.evenIfUnstable;
    }

    @Override
    public PromotionBadge isMet(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        Result r;
        if (!build.isBuilding() && ((r = build.getResult()) == Result.SUCCESS || this.evenIfUnstable && r == Result.UNSTABLE)) {
            return new SelfPromotionBadge();
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SelfPromotionCondition_DisplayName();
        }
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<AbstractBuild<?, ?>> {
        public RunListenerImpl() {
            super(AbstractBuild.class);
        }

        public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
            JobPropertyImpl jp = (JobPropertyImpl)build.getProject().getProperty(JobPropertyImpl.class);
            if (jp != null) {
                block2: for (PromotionProcess p : jp.getItems()) {
                    for (PromotionCondition cond : p.conditions) {
                        if (!(cond instanceof SelfPromotionCondition)) continue;
                        try {
                            p.considerPromotion2(build);
                            continue block2;
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error("Failed to promote a build"));
                        }
                    }
                }
            }
        }
    }
}

