/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.InvisibleAction;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.User;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.conditions.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.GrantedAuthority;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public class ManualCondition
extends PromotionCondition {
    private String users;
    private List<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
    public static final String MISSING_USER_ID_DISPLAY_STRING = "N/A";

    public String getUsers() {
        return this.users;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    @CheckForNull
    public ParameterDefinition getParameterDefinition(String name) {
        if (this.parameterDefinitions == null) {
            return null;
        }
        for (ParameterDefinition pd : this.parameterDefinitions) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    public Set<String> getUsersAsSet() {
        if (this.users == null || this.users.equals("")) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String user : this.users.split(",")) {
            if ((user = user.trim()).trim().length() <= 0) continue;
            set.add(user);
        }
        return set;
    }

    @Override
    public PromotionBadge isMet(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        List approvals = build.getActions(ManualApproval.class);
        for (ManualApproval approval : approvals) {
            if (!approval.name.equals(promotionProcess.getName())) continue;
            return approval.badge;
        }
        return null;
    }

    public boolean canApprove(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        if (!(this.getUsersAsSet().isEmpty() || this.isInUsersList() || this.isInGroupList())) {
            return false;
        }
        List approvals = build.getActions(ManualApproval.class);
        for (ManualApproval approval : approvals) {
            if (!approval.name.equals(promotionProcess.getName())) continue;
            return false;
        }
        return true;
    }

    public boolean isInUsersList() {
        Set<String> usersSet = this.getUsersAsSet();
        return usersSet.contains(Hudson.getAuthentication().getName());
    }

    public boolean isInGroupList() {
        GrantedAuthority[] authorities;
        Set<String> groups = this.getUsersAsSet();
        for (GrantedAuthority authority : authorities = Hudson.getAuthentication().getAuthorities()) {
            if (!groups.contains(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public Future<Promotion> approve(AbstractBuild<?, ?> build, PromotionProcess promotionProcess, List<ParameterValue> paramValues) throws IOException {
        if (this.canApprove(promotionProcess, build)) {
            ManualApproval approval = new ManualApproval(promotionProcess.getName(), paramValues);
            build.addAction((Action)approval);
            build.save();
            return promotionProcess.considerPromotion2(build, approval);
        }
        return null;
    }

    public List<ParameterValue> createDefaultValues() {
        ArrayList<ParameterValue> paramValues = new ArrayList<ParameterValue>();
        if (this.parameterDefinitions != null && !this.parameterDefinitions.isEmpty()) {
            for (ParameterDefinition d : this.parameterDefinitions) {
                paramValues.add(d.getDefaultParameterValue());
            }
        }
        return paramValues;
    }

    public Future<Promotion> approve(AbstractBuild<?, ?> build, PromotionProcess promotionProcess) throws IOException {
        List<ParameterValue> paramValues = this.createDefaultValues();
        return this.approve(build, promotionProcess, paramValues);
    }

    public void doApprove(StaplerRequest req, StaplerResponse rsp, @AncestorInPath PromotionProcess promotionProcess, @AncestorInPath AbstractBuild<?, ?> build) throws IOException, ServletException {
        JSONObject formData = req.getSubmittedForm();
        if (this.canApprove(promotionProcess, build)) {
            ArrayList<ParameterValue> paramValues = new ArrayList<ParameterValue>();
            if (this.parameterDefinitions != null && !this.parameterDefinitions.isEmpty()) {
                JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
                for (Object o : a) {
                    JSONObject jo = (JSONObject)o;
                    String name = jo.getString("name");
                    ParameterDefinition d = this.getParameterDefinition(name);
                    if (d == null) {
                        throw new IllegalArgumentException("No such parameter definition: " + name);
                    }
                    paramValues.add(d.createValue(req, jo));
                }
            }
            this.approve(build, promotionProcess, paramValues);
        }
        rsp.sendRedirect2("../../../..");
    }

    @Extension
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.ManualCondition_DisplayName();
        }

        public ManualCondition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ManualCondition instance = new ManualCondition();
            instance.users = formData.getString("users");
            instance.parameterDefinitions = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"parameters", (Collection)ParameterDefinition.all());
            return instance;
        }
    }

    public static final class Badge
    extends PromotionBadge {
        public String authenticationName = Hudson.getAuthentication().getName();
        private final List<ParameterValue> values;

        public Badge(List<ParameterValue> values) {
            this.values = values;
        }

        @Exported
        @Nonnull
        public String getUserName() {
            if (this.authenticationName == null) {
                return ManualCondition.MISSING_USER_ID_DISPLAY_STRING;
            }
            User u = User.get((String)this.authenticationName, (boolean)false, null);
            return u != null ? u.getDisplayName() : this.authenticationName;
        }

        @Exported
        public String getUserId() {
            if (this.authenticationName == null) {
                return ManualCondition.MISSING_USER_ID_DISPLAY_STRING;
            }
            return this.authenticationName;
        }

        @Exported
        public List<ParameterValue> getParameterValues() {
            return this.values != null ? this.values : Collections.emptyList();
        }

        @Override
        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (!(build instanceof Promotion)) {
                throw new IllegalStateException("Wrong build type. Expected a Promotion, but got " + build.getClass());
            }
            List<ParameterValue> params = ((Promotion)build).getParameterValues();
            if (params != null) {
                for (ParameterValue value : params) {
                    value.buildEnvVars(build, env);
                }
            }
        }
    }

    public static final class ManualApproval
    extends InvisibleAction {
        public String name;
        public Badge badge;

        public ManualApproval(String name, List<ParameterValue> values) {
            this.name = name;
            this.badge = new Badge(values);
        }
    }
}

