/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import groovy.lang.Binding;
import hudson.EnvVars;
import hudson.PluginManager;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.conditions.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedClasspathException;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroovyCondition
extends PromotionCondition {
    private static final Logger LOGGER = Logger.getLogger(GroovyCondition.class.getName());
    @CheckForNull
    private final String unmetQualificationLabel;
    @CheckForNull
    private final String metQualificationLabel;
    private final SecureGroovyScript script;

    @DataBoundConstructor
    public GroovyCondition(SecureGroovyScript script, String unmetQualificationLabel, String metQualificationLabel) {
        this.unmetQualificationLabel = Util.fixEmptyAndTrim((String)unmetQualificationLabel);
        this.metQualificationLabel = Util.fixEmptyAndTrim((String)metQualificationLabel);
        this.script = script.configuringWithNonKeyItem();
    }

    public SecureGroovyScript getScript() {
        return this.script;
    }

    public String getUnmetQualificationLabel() {
        return this.unmetQualificationLabel;
    }

    public String getMetQualificationLabel() {
        return this.metQualificationLabel;
    }

    public String getDisplayLabel() {
        return this.unmetQualificationLabel == null ? Messages.GroovyCondition_UnmetQualificationLabel() : this.unmetQualificationLabel;
    }

    @Override
    public PromotionBadge isMet(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        String displayLabel;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.log(Level.WARNING, "Missing Jenkins instance");
            return null;
        }
        PluginManager pluginManager = jenkins.getPluginManager();
        if (pluginManager == null) {
            LOGGER.log(Level.WARNING, "Unable to retrieve PluginManager");
            return null;
        }
        ClassLoader classLoader = pluginManager.uberClassLoader;
        Binding binding = new Binding();
        binding.setVariable("promotionProcess", (Object)promotionProcess);
        binding.setVariable("build", build);
        binding.setVariable("jenkins", (Object)jenkins);
        Object result = null;
        try {
            result = this.script.evaluate(classLoader, binding);
        }
        catch (RejectedAccessException e) {
            LOGGER.log(Level.WARNING, "Sandbox exception", e);
            return null;
        }
        catch (UnapprovedUsageException e) {
            LOGGER.log(Level.WARNING, "Unapproved script", e);
            return null;
        }
        catch (UnapprovedClasspathException e) {
            LOGGER.log(Level.WARNING, "Unapproved classpath", e);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Evaluation error", e);
            return null;
        }
        String string = displayLabel = this.metQualificationLabel == null ? Messages.GroovyCondition_MetQualificationLabel() : this.metQualificationLabel;
        if (Boolean.TRUE.equals(result)) {
            return new Badge(displayLabel, Collections.emptyMap());
        }
        if (result instanceof Map && !((Map)result).isEmpty()) {
            HashMap<String, String> variables = new HashMap<String, String>(((Map)result).size());
            for (Map.Entry entry : ((Map)result).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) continue;
                variables.put(key.toString(), value == null ? "" : value.toString());
            }
            return new Badge(displayLabel, variables);
        }
        return null;
    }

    public static final class Badge
    extends PromotionBadge {
        private final String displayLabel;
        private final Map<String, String> variables;

        public Badge(String displayLabel, Map<String, String> variables) {
            this.displayLabel = displayLabel;
            this.variables = variables;
        }

        public String getDisplayLabel() {
            return this.displayLabel;
        }

        @Override
        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            super.buildEnvVars(build, env);
            for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

