/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.conditions.Messages;
import hudson.plugins.promoted_builds.util.JenkinsHelper;
import hudson.security.ACL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class DownstreamPassCondition
extends PromotionCondition {
    private final String jobs;
    private final boolean evenIfUnstable;

    public DownstreamPassCondition(String jobs) {
        this(jobs, false);
    }

    public DownstreamPassCondition(String jobs, boolean evenIfUnstable) {
        this.jobs = jobs;
        this.evenIfUnstable = evenIfUnstable;
    }

    public String getJobs() {
        return this.jobs;
    }

    public boolean isEvenIfUnstable() {
        return this.evenIfUnstable;
    }

    @Override
    public PromotionBadge isMet(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        Badge badge = new Badge();
        PseudoDownstreamBuilds pdb = (PseudoDownstreamBuilds)build.getAction(PseudoDownstreamBuilds.class);
        EnvVars buildEnvironment = new EnvVars(build.getBuildVariables());
        block0: for (AbstractProject<?, ?> j : this.getJobList(build.getProject().getParent(), buildEnvironment)) {
            Result r;
            for (AbstractBuild abstractBuild : build.getDownstreamBuilds(j)) {
                if (abstractBuild.isBuilding() || (r = abstractBuild.getResult()) != Result.SUCCESS && (!this.evenIfUnstable || r != Result.UNSTABLE)) continue;
                badge.add(abstractBuild);
                continue block0;
            }
            if (pdb != null) {
                for (AbstractBuild abstractBuild : pdb.listBuilds(j)) {
                    if (abstractBuild.isBuilding() || (r = abstractBuild.getResult()) != Result.SUCCESS && (!this.evenIfUnstable || r != Result.UNSTABLE)) continue;
                    badge.add(abstractBuild);
                    continue block0;
                }
            }
            return null;
        }
        return badge;
    }

    @Deprecated
    public List<AbstractProject<?, ?>> getJobList(ItemGroup context) {
        return this.getJobList(context, null);
    }

    public List<AbstractProject<?, ?>> getJobList(ItemGroup context, EnvVars buildEnvironment) {
        ArrayList r = new ArrayList();
        String expandedJobs = DownstreamPassCondition.getExpandedJobs(this.jobs, buildEnvironment);
        if (expandedJobs == null) {
            return r;
        }
        for (String name : Util.tokenize((String)expandedJobs, (String)",")) {
            AbstractProject job = (AbstractProject)JenkinsHelper.getInstance().getItem(name.trim(), context, AbstractProject.class);
            if (job == null) continue;
            r.add(job);
        }
        return r;
    }

    private static String getExpandedJobs(@CheckForNull String jobs, @CheckForNull EnvVars environment) {
        if (environment == null) {
            return jobs;
        }
        if (jobs == null) {
            return null;
        }
        return environment.expand(jobs);
    }

    public boolean contains(ItemGroup ctx, AbstractProject<?, ?> job) {
        return this.contains(ctx, job, null);
    }

    public boolean contains(ItemGroup ctx, AbstractProject<?, ?> job, EnvVars environment) {
        String expandedJobs = DownstreamPassCondition.getExpandedJobs(this.jobs, environment);
        if (expandedJobs == null) {
            return false;
        }
        if (!expandedJobs.contains(job.getName())) {
            return false;
        }
        String name = job.getFullName();
        for (AbstractProject<?, ?> project : this.getJobList(ctx)) {
            if (!project.getFullName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(AbstractProject<?, ?> job) {
        return this.contains((ItemGroup)Jenkins.getInstance(), job);
    }

    public static class PseudoDownstreamBuilds
    extends InvisibleAction {
        final List<Fingerprint.BuildPtr> builds = new ArrayList<Fingerprint.BuildPtr>();

        public void add(AbstractBuild<?, ?> run) {
            this.builds.add(new Fingerprint.BuildPtr(run));
        }

        public List<AbstractBuild<?, ?>> listBuilds(AbstractProject<?, ?> job) {
            ArrayList list = new ArrayList();
            for (Fingerprint.BuildPtr b : this.builds) {
                Run r;
                if (!b.is(job) || !((r = b.getRun()) instanceof AbstractBuild)) continue;
                list.add((AbstractBuild)r);
            }
            return list;
        }
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<AbstractBuild<?, ?>> {
        public RunListenerImpl() {
            super(AbstractBuild.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
            EnvVars buildEnvironment = new EnvVars(build.getBuildVariables());
            SecurityContext previousCtx = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                for (AbstractProject j : JenkinsHelper.getInstance().getAllItems(AbstractProject.class)) {
                    boolean warned = false;
                    JobPropertyImpl jp = (JobPropertyImpl)j.getProperty(JobPropertyImpl.class);
                    if (jp == null) continue;
                    for (PromotionProcess p : jp.getItems()) {
                        boolean considerPromotion = false;
                        for (PromotionCondition cond : p.conditions) {
                            DownstreamPassCondition dpcond;
                            if (!(cond instanceof DownstreamPassCondition) || !(dpcond = (DownstreamPassCondition)cond).contains(j.getParent(), (AbstractProject)build.getParent(), buildEnvironment) || !j.getACL().hasPermission(previousCtx.getAuthentication(), Item.READ)) continue;
                            considerPromotion = true;
                            break;
                        }
                        if (!considerPromotion) continue;
                        try {
                            AbstractBuild u = build.getUpstreamRelationshipBuild(j);
                            if (u == null) {
                                Stack<List> stack = new Stack<List>();
                                stack.push(build.getCauses());
                                block8: while (!stack.isEmpty()) {
                                    for (Cause.UpstreamCause uc : Util.filter((List)((List)stack.pop()), Cause.UpstreamCause.class)) {
                                        if (uc.getUpstreamProject().equals(j.getFullName()) && (u = j.getBuildByNumber(uc.getUpstreamBuild())) != null) {
                                            PseudoDownstreamBuilds pdb = (PseudoDownstreamBuilds)u.getAction(PseudoDownstreamBuilds.class);
                                            if (pdb == null) {
                                                pdb = new PseudoDownstreamBuilds();
                                                u.addAction((Action)pdb);
                                            }
                                            pdb.add(build);
                                            u.save();
                                            continue block8;
                                        }
                                        stack.push(uc.getUpstreamCauses());
                                    }
                                }
                            }
                            if (u == null && build.getResult() == Result.SUCCESS && !warned) {
                                listener.getLogger().println("WARNING: " + j.getFullDisplayName() + " appears to use this job as a promotion criteria, but no fingerprint is recorded. Fingerprint needs to be enabled on both this job and " + j.getFullDisplayName() + ". See https://wiki.jenkins-ci.org/display/JENKINS/Fingerprint for more details");
                                warned = true;
                            }
                            if (u == null || p.considerPromotion2(u) == null) continue;
                            listener.getLogger().println("Promoted " + HyperlinkNote.encodeTo((String)('/' + u.getUrl()), (String)u.getFullDisplayName()));
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error("Failed to promote a build"));
                        }
                    }
                }
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousCtx);
            }
        }

        @Deprecated
        public static void rebuildCache() {
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DownstreamPassCondition_DisplayName();
        }

        public PromotionCondition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new DownstreamPassCondition(formData.getString("jobs"), formData.getBoolean("evenIfUnstable"));
        }

        public AutoCompletionCandidates doAutoCompleteJobs(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            List downstreams = project.getDownstreamProjects();
            List all = JenkinsHelper.getInstance().getItems(Item.class);
            ArrayList candidatesDownstreams = Lists.newArrayList();
            ArrayList candidatesOthers = Lists.newArrayList();
            for (Item i : all) {
                if (!i.hasPermission(Item.READ)) continue;
                LinkedHashSet names = Sets.newLinkedHashSet();
                names.add(i.getRelativeNameFrom((Item)project));
                names.add(i.getFullName());
                for (String name : names) {
                    if (!name.startsWith(value)) continue;
                    if (downstreams.contains(i)) {
                        candidatesDownstreams.add(name);
                        continue;
                    }
                    candidatesOthers.add(name);
                }
            }
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            candidates.add(candidatesDownstreams.toArray(new String[candidatesDownstreams.size()]));
            if (candidatesDownstreams.size() > 0 && candidatesOthers.size() > 0) {
                candidates.add("- - -");
            }
            candidates.add(candidatesOthers.toArray(new String[candidatesOthers.size()]));
            return candidates;
        }
    }

    public static final class Badge
    extends PromotionBadge {
        @Exported
        public final List<Fingerprint.BuildPtr> builds = new ArrayList<Fingerprint.BuildPtr>();

        void add(AbstractBuild<?, ?> b) {
            this.builds.add(new Fingerprint.BuildPtr(b));
        }
    }
}

