/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Api;
import hudson.model.PermalinkProjectAction;
import hudson.model.ProminentProjectAction;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class PromotedProjectAction
implements ProminentProjectAction,
PermalinkProjectAction {
    private static final int SUMMARY_SIZE = 10;
    public final AbstractProject<?, ?> owner;
    private final JobPropertyImpl property;

    public PromotedProjectAction(AbstractProject<?, ?> owner, JobPropertyImpl property) {
        this.owner = owner;
        this.property = property;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported
    public List<PromotionProcess> getProcesses() {
        return this.property.getActiveItems();
    }

    @CheckForNull
    public PromotionProcess getProcess(String name) {
        for (PromotionProcess pp : this.getProcesses()) {
            if (!pp.getName().equals(name)) continue;
            return pp;
        }
        return null;
    }

    public AbstractBuild<?, ?> getLatest(PromotionProcess p) {
        List<Promotion> list = this.getPromotions(p);
        return list.size() > 0 ? list.get(list.size() - 1) : null;
    }

    @Restricted(value={NoExternalUse.class})
    public List<PromotionProcess> getPromotionProcesses() {
        List<PromotionProcess> processes = null;
        processes = this.getProcesses();
        if (processes == null) {
            processes = new ArrayList<PromotionProcess>();
        }
        return processes;
    }

    @Restricted(value={NoExternalUse.class})
    public Status getStatus(PromotionProcess process) {
        List<Promotion> list = this.getPromotions(process);
        Promotion latest = list.size() > 0 ? list.get(list.size() - 1) : null;
        Status status = latest != null ? latest.getStatus() : null;
        return status;
    }

    public AbstractBuild<?, ?> getLatest(String name) {
        List<Promotion> list = this.getPromotions(this.getProcess(name));
        return list.size() > 0 ? list.get(list.size() - 1) : null;
    }

    public List<Promotion> getPromotions(PromotionProcess promotionProcess) {
        ArrayList<Promotion> list = new ArrayList<Promotion>();
        for (AbstractBuild build : this.owner.getBuilds()) {
            PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
            if (a == null || !a.contains(promotionProcess)) continue;
            list.addAll(a.getPromotionBuilds(promotionProcess));
        }
        Collections.sort(list);
        return list;
    }

    public List<Promotion> getPromotionsSummary(PromotionProcess promotionProcess) {
        List<Promotion> promotionList = this.getPromotions(promotionProcess);
        if (promotionList.size() > 10) {
            return promotionList.subList(promotionList.size() - 10, promotionList.size());
        }
        return promotionList;
    }

    public List<PermalinkProjectAction.Permalink> getPermalinks() {
        ArrayList<PermalinkProjectAction.Permalink> r = new ArrayList<PermalinkProjectAction.Permalink>();
        for (PromotionProcess pp : this.property.getActiveItems()) {
            r.add(pp.asPermalink());
        }
        return r;
    }

    @RequirePOST
    public HttpResponse doCreateProcess(@QueryParameter String name, StaplerRequest req) throws IOException {
        this.property.createProcessFromXml(name, (InputStream)req.getInputStream());
        return HttpResponses.ok();
    }

    public String getIconFileName() {
        return "star.png";
    }

    public String getDisplayName() {
        return "Promotion Status";
    }

    public String getUrlName() {
        return "promotion";
    }
}

