/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ItemPathResolver {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="We want to allow modifying it from Groovy scripts as a last resort")
    private static boolean ENABLE_LEGACY_RESOLUTION_AGAINST_ROOT = Boolean.getBoolean(ItemPathResolver.class + ".enableResolutionAgainstRoot");

    public static boolean isEnableLegacyResolutionAgainstRoot() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            ExtensionList extensions = jenkins.getExtensionList(ResolverManager.class);
            for (ResolverManager manager : extensions) {
                Boolean enableLegacyItemPathResolutionMode = manager.isEnableLegacyItemPathResolutionMode();
                if (enableLegacyItemPathResolutionMode == null) continue;
                return enableLegacyItemPathResolutionMode;
            }
        }
        return ENABLE_LEGACY_RESOLUTION_AGAINST_ROOT;
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public static <T extends Item> T getByPath(@Nonnull String path, @CheckForNull Item baseItem, @Nonnull Class<T> type) {
        ItemGroup relativeRoot;
        T item;
        TopLevelItem topLevelItem;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        if (ItemPathResolver.isEnableLegacyResolutionAgainstRoot() && (topLevelItem = jenkins.getItem(path)) != null && type.isAssignableFrom(topLevelItem.getClass())) {
            return (T)topLevelItem;
        }
        if (path.startsWith("/")) {
            return ItemPathResolver.findPath((ItemGroup)jenkins, path.substring(1), type);
        }
        if (baseItem != null && (item = ItemPathResolver.findPath(relativeRoot = baseItem instanceof ItemGroup ? (ItemGroup)baseItem : baseItem.getParent(), path, type)) != null) {
            return item;
        }
        return ItemPathResolver.findPath((ItemGroup)jenkins, path, type);
    }

    @CheckForNull
    private static <T extends Item> T findPath(@CheckForNull ItemGroup base, @Nonnull String path, @Nonnull Class<T> type) {
        Item item = ItemPathResolver.findPath(base, path);
        if (item != null && type.isAssignableFrom(item.getClass())) {
            return (T)item;
        }
        return null;
    }

    @CheckForNull
    private static Item findPath(@CheckForNull ItemGroup base, @Nonnull String path) {
        ItemGroup pointer = base;
        StringTokenizer t = new StringTokenizer(path, "/");
        while (pointer != null && t.hasMoreTokens()) {
            String current = t.nextToken();
            if (current.equals("..")) {
                if (pointer instanceof Item) {
                    Item currentItem = (Item)pointer;
                    pointer = currentItem.getParent();
                    continue;
                }
                pointer = null;
                continue;
            }
            if (current.equals(".")) continue;
            Item item = pointer.getItem(current);
            if (!t.hasMoreTokens()) {
                return item;
            }
            if (item instanceof ItemGroup) {
                pointer = (ItemGroup)item;
                continue;
            }
            pointer = null;
        }
        if (pointer instanceof Item) {
            return (Item)pointer;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class ResolverManager
    implements ExtensionPoint {
        @CheckForNull
        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Third state for the logic")
        public Boolean isEnableLegacyItemPathResolutionMode() {
            return null;
        }
    }
}

