/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.integrations.jobdsl;

import groovy.lang.Closure;
import groovy.util.Node;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.conditions.DownstreamPassCondition;
import hudson.plugins.promoted_builds.conditions.ParameterizedSelfPromotionCondition;
import hudson.plugins.promoted_builds.conditions.SelfPromotionCondition;
import hudson.plugins.promoted_builds.conditions.UpstreamPromotionCondition;
import hudson.plugins.promoted_builds.integrations.jobdsl.ConditionsContext;
import hudson.plugins.promoted_builds.integrations.jobdsl.JobDslManualCondition;
import hudson.plugins.promoted_builds.integrations.jobdsl.ReleasePromotionCondition;
import java.util.ArrayList;
import java.util.List;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.step.StepContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslEnvironment;

class PromotionContext
implements Context {
    private final DslEnvironment dslEnvironment;
    private List<PromotionCondition> conditions = new ArrayList<PromotionCondition>();
    private List<Node> actions = new ArrayList<Node>();
    private String icon;
    private String restrict;
    private String name;

    public void name(String name) {
        this.name = name;
    }

    public void icon(String icon) {
        this.icon = icon;
    }

    public void restrict(String restrict) {
        this.restrict = restrict;
    }

    public PromotionContext(DslEnvironment dslEnvironment) {
        this.dslEnvironment = dslEnvironment;
    }

    public void conditions(Closure<?> conditionClosure) {
        ConditionsContext conditionContext = new ConditionsContext(this.dslEnvironment);
        ContextExtensionPoint.executeInContext(conditionClosure, (Context)conditionContext);
        if (conditionContext.isSelfPromotion()) {
            this.conditions.add(new SelfPromotionCondition(conditionContext.isEvenIfUnstable()));
        }
        if (conditionContext.isParameterizedSelfPromotion()) {
            this.conditions.add(new ParameterizedSelfPromotionCondition(conditionContext.isEvenIfUnstableParameterized(), conditionContext.getParameterName(), conditionContext.getParameterValue()));
        }
        if (conditionContext.isManual()) {
            JobDslManualCondition condition = new JobDslManualCondition();
            condition.setUsers(conditionContext.getUsers());
            if (conditionContext.getParams() != null) {
                condition.setParameterDefinitionNodes(conditionContext.getParams().values());
            }
            this.conditions.add(condition);
        }
        if (conditionContext.isReleaseBuild()) {
            this.conditions.add(new ReleasePromotionCondition());
        }
        if (conditionContext.isDownstreamPass()) {
            this.conditions.add(new DownstreamPassCondition(conditionContext.getJobs(), conditionContext.isEvenIfUnstableDownstream()));
        }
        if (conditionContext.isUpstreamPromotion()) {
            this.conditions.add(new UpstreamPromotionCondition(conditionContext.getPromotionNames()));
        }
    }

    public void actions(Closure<?> actionsClosure) {
        StepContext stepContext = (StepContext)this.dslEnvironment.createContext(StepContext.class);
        ContextExtensionPoint.executeInContext(actionsClosure, (Context)stepContext);
        this.actions.addAll(stepContext.getStepNodes());
    }

    public List<PromotionCondition> getConditions() {
        return this.conditions;
    }

    public List<Node> getActions() {
        return this.actions;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getRestrict() {
        return this.restrict;
    }

    public String getName() {
        return this.name;
    }
}

