/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.conditions.Messages;
import hudson.plugins.promoted_builds.conditions.ParameterizedSelfPromotionBadge;
import hudson.plugins.promoted_builds.conditions.SelfPromotionCondition;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParameterizedSelfPromotionCondition
extends SelfPromotionCondition {
    private final String parameterName;
    private final String parameterValue;

    @DataBoundConstructor
    public ParameterizedSelfPromotionCondition(boolean evenIfUnstable, String parameterName, String parameterValue) {
        super(evenIfUnstable);
        this.parameterName = parameterName;
        this.parameterValue = parameterValue;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    @Override
    public PromotionBadge isMet(PromotionProcess promotionProcess, AbstractBuild<?, ?> build) {
        Map vars;
        if (super.isMet(promotionProcess, build) != null && (vars = build.getBuildVariables()).containsKey(this.parameterName) && ((String)vars.get(this.parameterName)).equals(this.parameterValue)) {
            System.out.println("Matched parameters!");
            return new ParameterizedSelfPromotionBadge();
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.ParameterizedSelfPromotionCondition_DisplayName();
        }
    }
}

