/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.conditions.ManualCondition;
import hudson.util.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class Status {
    public final String name;
    private final PromotionBadge[] badges;
    public final Calendar timestamp = new GregorianCalendar();
    private int promotion = -1;
    private List<Integer> promotionAttempts = new ArrayList<Integer>();
    transient PromotedBuildAction parent;
    private static final Logger LOGGER = Logger.getLogger(Status.class.getName());

    public Status(PromotionProcess process, Collection<? extends PromotionBadge> badges) {
        this.name = process.getName();
        this.badges = badges.toArray(new PromotionBadge[badges.size()]);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public PromotedBuildAction getParent() {
        AbstractBuild<?, ?> target;
        if (this.parent == null && (target = this.getTarget()) != null) {
            this.parent = (PromotedBuildAction)target.getAction(PromotedBuildAction.class);
        }
        return this.parent;
    }

    @Exported
    @CheckForNull
    public PromotionProcess getProcess() {
        assert (this.parent != null) : this.name;
        AbstractProject<?, ?> project = this.parent.getProject();
        assert (project != null) : this.parent;
        JobPropertyImpl jp = (JobPropertyImpl)project.getProperty(JobPropertyImpl.class);
        if (jp == null) {
            return null;
        }
        return jp.getItem(this.name);
    }

    @Nonnull
    public String getIcon(String size) {
        String baseName;
        PromotionProcess p = this.getProcess();
        if (p == null) {
            baseName = "star-gold";
        } else {
            Promotion l = this.getLast();
            if (l != null && l.getResult() != Result.SUCCESS) {
                return Jenkins.RESOURCE_PATH + "/images/" + size + "/error.png";
            }
            baseName = p.getIcon();
        }
        return Jenkins.RESOURCE_PATH + "/plugin/promoted-builds/icons/" + size + "/" + baseName + ".png";
    }

    @CheckForNull
    public AbstractBuild<?, ?> getTarget() {
        PromotedBuildAction _parent = this.getParent();
        return _parent != null ? _parent.owner : null;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        for (PromotionBadge badge : this.badges) {
            badge.buildEnvVars(build, env);
        }
    }

    public String getTimestampString() {
        long duration = new GregorianCalendar().getTimeInMillis() - this.timestamp.getTimeInMillis();
        return Util.getTimeSpanString((long)duration);
    }

    public String getDelayString(AbstractBuild<?, ?> owner) {
        long duration = this.timestamp.getTimeInMillis() - owner.getTimestamp().getTimeInMillis() - owner.getDuration();
        return Util.getTimeSpanString((long)duration);
    }

    public boolean isFor(PromotionProcess process) {
        return process.getName().equals(this.name);
    }

    @CheckForNull
    public Promotion getSuccessfulPromotion(JobPropertyImpl jp) {
        PromotionProcess p;
        if (this.promotion >= 0 && (p = jp.getItem(this.name)) != null) {
            return (Promotion)p.getBuildByNumber(this.promotion);
        }
        return null;
    }

    public boolean isPromotionSuccessful() {
        return this.promotion >= 0;
    }

    public boolean isPromotionAttempted() {
        return !this.promotionAttempts.isEmpty();
    }

    public boolean isInQueue() {
        PromotionProcess p = this.getProcess();
        AbstractBuild<?, ?> target = this.getTarget();
        return p != null && target != null && p.isInQueue(target);
    }

    @Exported
    public List<PromotionBadge> getBadges() {
        return Arrays.asList(this.badges);
    }

    void addPromotionAttempt(Promotion p) {
        this.promotionAttempts.add(p.getNumber());
    }

    void onSuccessfulPromotion(Promotion p) {
        this.promotion = p.getNumber();
    }

    @CheckForNull
    public Promotion getLastSuccessful() {
        PromotionProcess p = this.getProcess();
        if (p == null) {
            return null;
        }
        for (Integer n : Iterators.reverse(this.promotionAttempts)) {
            Promotion b = (Promotion)p.getBuildByNumber(n);
            if (b == null || b.getResult() != Result.SUCCESS) continue;
            return b;
        }
        return null;
    }

    @CheckForNull
    public Promotion getLastFailed() {
        PromotionProcess p = this.getProcess();
        if (p == null) {
            return null;
        }
        for (Integer n : Iterators.reverse(this.promotionAttempts)) {
            Promotion b = (Promotion)p.getBuildByNumber(n);
            if (b == null || b.getResult() == Result.SUCCESS) continue;
            return b;
        }
        return null;
    }

    @CheckForNull
    public Promotion getLast() {
        PromotionProcess p = this.getProcess();
        if (p == null) {
            return null;
        }
        for (Integer n : Iterators.reverse(this.promotionAttempts)) {
            Promotion b = (Promotion)p.getBuildByNumber(n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public Boolean isLastAnError() {
        Promotion l = this.getLast();
        return l != null && l.getResult() != Result.SUCCESS;
    }

    @Exported
    public List<Promotion> getPromotionBuilds() {
        ArrayList<Promotion> builds = new ArrayList<Promotion>();
        PromotionProcess p = this.getProcess();
        if (p != null) {
            for (Integer n : Iterators.reverse(this.promotionAttempts)) {
                Promotion b = (Promotion)p.getBuildByNumber(n);
                if (b == null) continue;
                builds.add(b);
            }
        }
        return builds;
    }

    @CheckForNull
    public Promotion getPromotionBuild(int number) {
        PromotionProcess p = this.getProcess();
        return p != null ? (Promotion)p.getBuildByNumber(number) : null;
    }

    public boolean isManuallyApproved() {
        PromotionProcess process = this.getProcess();
        if (process == null) {
            return false;
        }
        ManualCondition manualCondition = (ManualCondition)process.getPromotionCondition(ManualCondition.class.getName());
        return manualCondition != null;
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Future<Promotion> f;
        PromotionProcess process = this.getProcess();
        if (process == null) {
            throw new AbortException("Cannot retrieve the promotion process");
        }
        AbstractBuild<?, ?> target = this.getTarget();
        if (target == null) {
            throw new AbortException("Cannot get the target build to be promoted");
        }
        ManualCondition manualCondition = (ManualCondition)process.getPromotionCondition(ManualCondition.class.getName());
        if (!(target.hasPermission(Promotion.PROMOTE) || manualCondition != null && (manualCondition.getUsersAsSet().isEmpty() || manualCondition.isInUsersList() || manualCondition.isInGroupList()))) {
            return;
        }
        JSONObject formData = req.getSubmittedForm();
        ArrayList<ParameterValue> paramValues = null;
        if (formData != null) {
            List<ParameterDefinition> parameterDefinitions;
            paramValues = new ArrayList<ParameterValue>();
            if (manualCondition != null && (parameterDefinitions = manualCondition.getParameterDefinitions()) != null && !parameterDefinitions.isEmpty()) {
                JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
                for (Object o : a) {
                    JSONObject jo = (JSONObject)o;
                    String name = jo.getString("name");
                    ParameterDefinition d = manualCondition.getParameterDefinition(name);
                    if (d == null) {
                        throw new IllegalArgumentException("No such parameter definition: " + name);
                    }
                    paramValues.add(d.createValue(req, jo));
                }
            }
        }
        if (paramValues == null) {
            paramValues = new ArrayList();
        }
        if ((f = process.scheduleBuild2(target, (Cause)new Cause.UserCause(), paramValues)) == null) {
            LOGGER.warning("Failing to schedule the promotion of " + target);
        }
        rsp.forwardToPreviousPage(req);
    }
}

