/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.FreeStyleProject;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PermalinkProjectAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StringParameterValue;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelExpression;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.Messages;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionTargetAction;
import hudson.plugins.promoted_builds.Status;
import hudson.plugins.promoted_builds.conditions.ManualCondition;
import hudson.plugins.promoted_builds.util.JenkinsHelper;
import hudson.security.ACL;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class PromotionProcess
extends AbstractProject<PromotionProcess, Promotion>
implements Saveable,
Describable<PromotionProcess> {
    public final DescribableList<PromotionCondition, PromotionConditionDescriptor> conditions = new DescribableList((Saveable)this);
    public String icon;
    public String assignedLabel;
    public String isVisible;
    private List<BuildStep> buildSteps = new ArrayList<BuildStep>();
    private static final Logger LOGGER = Logger.getLogger(PromotionProcess.class.getName());

    PromotionProcess(JobPropertyImpl property, String name) {
        super((ItemGroup)property, name);
    }

    PromotionProcess(ItemGroup parent, String name) {
        super(parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PromotionProcess fromJson(StaplerRequest req, JSONObject o) throws Descriptor.FormException, IOException {
        String name = o.getString("name");
        try {
            Jenkins.checkGoodName((String)name);
        }
        catch (Failure f) {
            throw new Descriptor.FormException(f.getMessage(), name);
        }
        PromotionProcess p = new PromotionProcess(null, name);
        BulkChange bc = new BulkChange((Saveable)p);
        try {
            p.configure(req, o);
        }
        finally {
            bc.abort();
        }
        return p;
    }

    public void doSetName(String name) {
        super.doSetName(name);
    }

    void configure(StaplerRequest req, JSONObject c) throws Descriptor.FormException, IOException {
        this.conditions.rebuild(req, c.optJSONObject("conditions"), PromotionCondition.all());
        this.buildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)c, (String)"buildStep", PromotionProcess.getAll());
        this.icon = c.getString("icon");
        this.assignedLabel = c.optBoolean("hasAssignedLabel") ? Util.fixEmptyAndTrim((String)c.optString("assignedLabelString")) : null;
        this.isVisible = c.getString("isVisible");
        this.save();
    }

    public AbstractProject getRootProject() {
        return this.getParent().getOwner().getRootProject();
    }

    public JobPropertyImpl getParent() {
        return (JobPropertyImpl)super.getParent();
    }

    public AbstractProject<?, ?> getOwner() {
        return this.getParent().getOwner();
    }

    public ACL getACL() {
        return this.getOwner().getACL();
    }

    public boolean supportsMakeDisabled() {
        return true;
    }

    @CheckForNull
    public PromotionCondition getPromotionCondition(String promotionClassName) {
        for (PromotionCondition condition : this.conditions) {
            if (!condition.getClass().getName().equals(promotionClassName)) continue;
            return condition;
        }
        return null;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return new DescribableList((Saveable)this);
    }

    protected Class<Promotion> getBuildClass() {
        return Promotion.class;
    }

    public List<BuildStep> getBuildSteps() {
        return this.buildSteps;
    }

    public String getAssignedLabelString() {
        if (this.assignedLabel == null) {
            return null;
        }
        try {
            LabelExpression.parseExpression((String)this.assignedLabel);
            return this.assignedLabel;
        }
        catch (ANTLRException e) {
            return LabelAtom.escape((String)this.assignedLabel);
        }
    }

    public Label getAssignedLabel() {
        if (this.assignedLabel == null) {
            return this.getOwner().getAssignedLabel();
        }
        return JenkinsHelper.getInstance().getLabel(this.assignedLabel);
    }

    public JDK getJDK() {
        return this.getOwner().getJDK();
    }

    @CheckForNull
    public String getCustomWorkspace() {
        AbstractProject<?, ?> p = this.getOwner();
        if (p instanceof FreeStyleProject) {
            return ((FreeStyleProject)p).getCustomWorkspace();
        }
        return null;
    }

    public String getIcon() {
        return PromotionProcess.getIcon(this.icon);
    }

    public String getIsVisible() {
        return this.isVisible;
    }

    public boolean isVisible() {
        if (this.isVisible == null) {
            return true;
        }
        AbstractProject<?, ?> job = this.getOwner();
        if (job == null) {
            return true;
        }
        String expandedIsVisible = this.isVisible;
        EnvVars environment = PromotionProcess.getDefaultParameterValuesAsEnvVars(job);
        if (environment != null) {
            expandedIsVisible = environment.expand(expandedIsVisible);
        }
        if (expandedIsVisible == null) {
            return true;
        }
        return !expandedIsVisible.toLowerCase().equals("false");
    }

    private static EnvVars getDefaultParameterValuesAsEnvVars(AbstractProject owner) {
        EnvVars envVars = null;
        ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)owner.getProperty(ParametersDefinitionProperty.class);
        if (parametersDefinitionProperty != null) {
            envVars = new EnvVars();
            for (ParameterDefinition parameterDefinition : parametersDefinitionProperty.getParameterDefinitions()) {
                ParameterValue defaultParameterValue = parameterDefinition.getDefaultParameterValue();
                if (defaultParameterValue == null || !(defaultParameterValue instanceof StringParameterValue)) continue;
                envVars.put(parameterDefinition.getName(), ((StringParameterValue)defaultParameterValue).value);
            }
            EnvVars.resolve((Map)envVars);
        }
        return envVars;
    }

    @Nonnull
    private static String getIcon(@CheckForNull String sIcon) {
        if (sIcon == null || sIcon.equals("")) {
            return "star-gold";
        }
        return sIcon;
    }

    @Nonnull
    public List<PromotionBadge> getMetQualifications(AbstractBuild<?, ?> build) {
        ArrayList<PromotionBadge> badges = new ArrayList<PromotionBadge>();
        for (PromotionCondition cond : this.conditions) {
            PromotionBadge b = cond.isMet(this, build);
            if (b == null) continue;
            badges.add(b);
        }
        return badges;
    }

    @Nonnull
    public List<PromotionCondition> getUnmetConditions(AbstractBuild<?, ?> build) {
        ArrayList<PromotionCondition> unmetConditions = new ArrayList<PromotionCondition>();
        for (PromotionCondition cond : this.conditions) {
            if (cond.isMet(this, build) != null) continue;
            unmetConditions.add(cond);
        }
        return unmetConditions;
    }

    @CheckForNull
    public Status isMet(AbstractBuild<?, ?> build) {
        ArrayList<PromotionBadge> badges = new ArrayList<PromotionBadge>();
        for (PromotionCondition cond : this.conditions) {
            PromotionBadge b = cond.isMet(this, build);
            if (b == null) {
                return null;
            }
            badges.add(b);
        }
        return new Status(this, badges);
    }

    @Deprecated
    public boolean considerPromotion(AbstractBuild<?, ?> build) throws IOException {
        return this.considerPromotion2(build) != null;
    }

    @CheckForNull
    public Future<Promotion> considerPromotion2(AbstractBuild<?, ?> build) throws IOException {
        LOGGER.fine("Considering the promotion of " + build + " via " + this.getName() + " without parmeters");
        List<ParameterValue> params = new ArrayList<ParameterValue>();
        List approvals = build.getActions(ManualCondition.ManualApproval.class);
        for (ManualCondition.ManualApproval approval : approvals) {
            if (!approval.name.equals(this.getName())) continue;
            LOGGER.fine("Getting parameters from existing manual promotion");
            params = approval.badge.getParameterValues();
            LOGGER.finer("Using paramters: " + params.toString());
        }
        return this.considerPromotion2(build, params);
    }

    @CheckForNull
    public Future<Promotion> considerPromotion2(AbstractBuild<?, ?> build, List<ParameterValue> params) throws IOException {
        if (!this.isActive()) {
            return null;
        }
        PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
        if (a != null && a.contains(this)) {
            return null;
        }
        LOGGER.fine("Considering the promotion of " + build + " via " + this.getName() + " with parameters");
        Status qualification = this.isMet(build);
        if (qualification == null) {
            return null;
        }
        LOGGER.fine("Promotion condition of " + build + " is met: " + qualification);
        Future<Promotion> f = this.promote2(build, (Cause)new Cause.UserCause(), qualification, params);
        if (f == null) {
            LOGGER.warning(build + " qualifies for a promotion but the queueing failed.");
        }
        return f;
    }

    public void promote(AbstractBuild<?, ?> build, Cause cause, PromotionBadge ... badges) throws IOException {
        this.promote2(build, cause, new Status(this, Arrays.asList(badges)));
    }

    public void promote(AbstractBuild<?, ?> build, Cause cause, Status qualification) throws IOException {
        this.promote2(build, cause, qualification);
    }

    public Future<Promotion> promote2(AbstractBuild<?, ?> build, Cause cause, Status qualification) throws IOException {
        return this.promote2(build, cause, qualification, null);
    }

    public Future<Promotion> promote2(AbstractBuild<?, ?> build, Cause cause, Status qualification, List<ParameterValue> params) throws IOException {
        PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
        if (a != null) {
            a.add(qualification);
        } else {
            build.addAction((Action)new PromotedBuildAction(build, qualification));
            build.save();
        }
        return this.scheduleBuild2(build, cause, params);
    }

    @Deprecated
    public boolean scheduleBuild() {
        return super.scheduleBuild();
    }

    public boolean scheduleBuild(@Nonnull AbstractBuild<?, ?> build) {
        return this.scheduleBuild(build, (Cause)new Cause.UserCause());
    }

    @Deprecated
    public boolean scheduleBuild(@Nonnull AbstractBuild<?, ?> build, @Nonnull Cause cause) {
        return this.scheduleBuild2(build, cause) != null;
    }

    @CheckForNull
    public Future<Promotion> scheduleBuild2(@Nonnull AbstractBuild<?, ?> build, Cause cause, @CheckForNull List<ParameterValue> params) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add((Object)Promotion.PromotionParametersAction.buildFor(build, params));
        actions.add((Object)new PromotionTargetAction(build));
        return super.scheduleBuild2(0, cause, actions.toArray(new Action[actions.size()]));
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        throw HttpResponses.error((int)404, (String)"Promotion processes may not be built directly");
    }

    public Future<Promotion> scheduleBuild2(@Nonnull AbstractBuild<?, ?> build, @Nonnull Cause cause) {
        return this.scheduleBuild2(build, cause, null);
    }

    public boolean isInQueue(@Nonnull AbstractBuild<?, ?> build) {
        for (Queue.Item item : JenkinsHelper.getInstance().getQueue().getItems((Queue.Task)this)) {
            if (((PromotionTargetAction)item.getAction(PromotionTargetAction.class)).resolve(this) != build) continue;
            return true;
        }
        return false;
    }

    public boolean isFingerprintConfigured() {
        return false;
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        throw new UnsupportedOperationException();
    }

    public static List<Descriptor<? extends BuildStep>> getAll() {
        ArrayList<Descriptor<? extends BuildStep>> list = new ArrayList<Descriptor<? extends BuildStep>>();
        PromotionProcess.addTo((List<? extends Descriptor<? extends BuildStep>>)Builder.all(), list);
        PromotionProcess.addTo((List<? extends Descriptor<? extends BuildStep>>)Publisher.all(), list);
        return list;
    }

    private static void addTo(List<? extends Descriptor<? extends BuildStep>> source, List<Descriptor<? extends BuildStep>> list) {
        for (Descriptor<? extends BuildStep> descriptor : source) {
            BuildStepDescriptor bsd;
            if (!(descriptor instanceof BuildStepDescriptor) || !(bsd = (BuildStepDescriptor)descriptor).isApplicable(PromotionProcess.class)) continue;
            list.add(descriptor);
        }
    }

    public PermalinkProjectAction.Permalink asPermalink() {
        return new PermalinkProjectAction.Permalink(){

            public String getDisplayName() {
                return Messages.PromotionProcess_PermalinkDisplayName(PromotionProcess.this.getDisplayName());
            }

            public String getId() {
                return PromotionProcess.this.getName();
            }

            public Run<?, ?> resolve(Job<?, ?> job) {
                String id = this.getId();
                for (Run build : job.getBuilds()) {
                    PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
                    if (a == null || !a.contains(id)) continue;
                    return build;
                }
                return null;
            }
        };
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)JenkinsHelper.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public String getShortUrl() {
        return "process/" + Util.rawEncode((String)this.getName()) + '/';
    }

    public boolean isActive() {
        return !this.isDisabled();
    }

    public Future<Promotion> considerPromotion2(AbstractBuild<?, ?> build, ManualCondition.ManualApproval approval) throws IOException {
        return this.considerPromotion2(build, approval.badge.getParameterValues());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PromotionProcess> {
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="exposed for Jelly")
        public final Class<PromotionProcess> promotionProcessType = PromotionProcess.class;

        public String getDisplayName() {
            return "Promotion Process";
        }

        public FormValidation doCheckLabelString(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.ok();
            }
            try {
                Label.parseExpression((String)value);
            }
            catch (ANTLRException e) {
                return FormValidation.error((Throwable)e, (String)Messages.JobPropertyImpl_LabelString_InvalidBooleanExpression(e.getMessage()));
            }
            if (JenkinsHelper.getInstance().getLabel(value).isEmpty()) {
                return FormValidation.warning((String)Messages.JobPropertyImpl_LabelString_NoMatch());
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteAssignedLabelString(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            Set labels = JenkinsHelper.getInstance().getLabels();
            List<String> queries = new AutoCompleteSeeder(value).getSeeds();
            for (String term : queries) {
                for (Label l : labels) {
                    if (!l.getName().startsWith(term)) continue;
                    c.add(l.getName());
                }
            }
            return c;
        }

        public List<PromotionConditionDescriptor> getApplicableConditions(AbstractProject<?, ?> p) {
            return p == null ? PromotionCondition.all() : PromotionCondition.getApplicableTriggers(p);
        }

        public List<PromotionConditionDescriptor> getApplicableConditions(Object context) {
            return PromotionCondition.all();
        }

        public List<Descriptor<? extends BuildStep>> getApplicableBuildSteps() {
            return PromotionProcess.getAll();
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if ((name = Util.fixEmptyAndTrim((String)name)) == null) {
                return FormValidation.error((String)Messages.JobPropertyImpl_ValidateRequired());
            }
            try {
                Jenkins.checkGoodName((String)name);
            }
            catch (Failure f) {
                return FormValidation.error((String)f.getMessage());
            }
            return FormValidation.ok();
        }

        static class AutoCompleteSeeder {
            private String source;

            AutoCompleteSeeder(String source) {
                this.source = source;
            }

            List<String> getSeeds() {
                ArrayList<String> terms = new ArrayList<String>();
                boolean trailingQuote = this.source.endsWith("\"");
                boolean leadingQuote = this.source.startsWith("\"");
                boolean trailingSpace = this.source.endsWith(" ");
                if (trailingQuote || trailingSpace && !leadingQuote) {
                    terms.add("");
                } else if (leadingQuote) {
                    int quote = this.source.lastIndexOf(34);
                    if (quote == 0) {
                        terms.add(this.source.substring(1));
                    } else {
                        terms.add("");
                    }
                } else {
                    int space = this.source.lastIndexOf(32);
                    if (space > -1) {
                        terms.add(this.source.substring(space + 1));
                    } else {
                        terms.add(this.source);
                    }
                }
                return terms;
            }
        }
    }
}

