// CHECKSTYLE:OFF

package hudson.plugins.promoted_builds;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PromotionCause.ShortDescription}: {@code Started by
     * promotion {0} for project "{1}", build number {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by promotion {0} for project "{1}", build number {2}}
     */
    public static String PromotionCause_ShortDescription(Object arg0, Object arg1, Object arg2) {
        return holder.format("PromotionCause.ShortDescription", arg0, arg1, arg2);
    }

    /**
     * Key {@code PromotionCause.ShortDescription}: {@code Started by
     * promotion {0} for project "{1}", build number {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by promotion {0} for project "{1}", build number {2}}
     */
    public static Localizable _PromotionCause_ShortDescription(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "PromotionCause.ShortDescription", arg0, arg1, arg2);
    }

    /**
     * Key {@code KeepBuildForEverAction.console.keepingBuild}: {@code
     * Marking build to keep forever.}.
     * 
     * @return
     *     {@code Marking build to keep forever.}
     */
    public static String KeepBuildForEverAction_console_keepingBuild() {
        return holder.format("KeepBuildForEverAction.console.keepingBuild");
    }

    /**
     * Key {@code KeepBuildForEverAction.console.keepingBuild}: {@code
     * Marking build to keep forever.}.
     * 
     * @return
     *     {@code Marking build to keep forever.}
     */
    public static Localizable _KeepBuildForEverAction_console_keepingBuild() {
        return new Localizable(holder, "KeepBuildForEverAction.console.keepingBuild");
    }

    /**
     * Key {@code LastBuildPromotionStatusColumn.DisplayName}: {@code Last
     * Build Promotion Status}.
     * 
     * @return
     *     {@code Last Build Promotion Status}
     */
    public static String LastBuildPromotionStatusColumn_DisplayName() {
        return holder.format("LastBuildPromotionStatusColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildPromotionStatusColumn.DisplayName}: {@code Last
     * Build Promotion Status}.
     * 
     * @return
     *     {@code Last Build Promotion Status}
     */
    public static Localizable _LastBuildPromotionStatusColumn_DisplayName() {
        return new Localizable(holder, "LastBuildPromotionStatusColumn.DisplayName");
    }

    /**
     * Key {@code Promotion.RunnerImpl.SchedulingBuild}: {@code scheduling
     * build for {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code scheduling build for {0}}
     */
    public static String Promotion_RunnerImpl_SchedulingBuild(Object arg0) {
        return holder.format("Promotion.RunnerImpl.SchedulingBuild", arg0);
    }

    /**
     * Key {@code Promotion.RunnerImpl.SchedulingBuild}: {@code scheduling
     * build for {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code scheduling build for {0}}
     */
    public static Localizable _Promotion_RunnerImpl_SchedulingBuild(Object arg0) {
        return new Localizable(holder, "Promotion.RunnerImpl.SchedulingBuild", arg0);
    }

    /**
     * Key {@code PromotionStatusColumn.DisplayName}: {@code Build
     * Promotions}.
     * 
     * @return
     *     {@code Build Promotions}
     */
    public static String PromotionStatusColumn_DisplayName() {
        return holder.format("PromotionStatusColumn.DisplayName");
    }

    /**
     * Key {@code PromotionStatusColumn.DisplayName}: {@code Build
     * Promotions}.
     * 
     * @return
     *     {@code Build Promotions}
     */
    public static Localizable _PromotionStatusColumn_DisplayName() {
        return new Localizable(holder, "PromotionStatusColumn.DisplayName");
    }

    /**
     * Key {@code PromotionProcess.PermalinkDisplayName}: {@code Latest
     * promotion:{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Latest promotion:{0}}
     */
    public static String PromotionProcess_PermalinkDisplayName(Object arg0) {
        return holder.format("PromotionProcess.PermalinkDisplayName", arg0);
    }

    /**
     * Key {@code PromotionProcess.PermalinkDisplayName}: {@code Latest
     * promotion:{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Latest promotion:{0}}
     */
    public static Localizable _PromotionProcess_PermalinkDisplayName(Object arg0) {
        return new Localizable(holder, "PromotionProcess.PermalinkDisplayName", arg0);
    }

    /**
     * Key {@code JobPropertyImpl.ValidateRequired}: {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String JobPropertyImpl_ValidateRequired() {
        return holder.format("JobPropertyImpl.ValidateRequired");
    }

    /**
     * Key {@code JobPropertyImpl.ValidateRequired}: {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _JobPropertyImpl_ValidateRequired() {
        return new Localizable(holder, "JobPropertyImpl.ValidateRequired");
    }

    /**
     * Key {@code Shared.noSuchProject}: {@code No such project ‘{0}’.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’.}
     */
    public static String Shared_noSuchProject(Object arg0) {
        return holder.format("Shared.noSuchProject", arg0);
    }

    /**
     * Key {@code Shared.noSuchProject}: {@code No such project ‘{0}’.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’.}
     */
    public static Localizable _Shared_noSuchProject(Object arg0) {
        return new Localizable(holder, "Shared.noSuchProject", arg0);
    }

    /**
     * Key {@code KeepBuildForEverAction.console.promotionNotGoodEnough}:
     * {@code Promotion build result [{0}] is not good enough. Not keeping
     * build.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Promotion build result [{0}] is not good enough. Not keeping
     *     build.}
     */
    public static String KeepBuildForEverAction_console_promotionNotGoodEnough(Object arg0) {
        return holder.format("KeepBuildForEverAction.console.promotionNotGoodEnough", arg0);
    }

    /**
     * Key {@code KeepBuildForEverAction.console.promotionNotGoodEnough}:
     * {@code Promotion build result [{0}] is not good enough. Not keeping
     * build.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Promotion build result [{0}] is not good enough. Not keeping
     *     build.}
     */
    public static Localizable _KeepBuildForEverAction_console_promotionNotGoodEnough(Object arg0) {
        return new Localizable(holder, "KeepBuildForEverAction.console.promotionNotGoodEnough", arg0);
    }

    /**
     * Key {@code KeepBuildForEverAction.descriptor.displayName}: {@code Keep
     * Build Forever}.
     * 
     * @return
     *     {@code Keep Build Forever}
     */
    public static String KeepBuildForEverAction_descriptor_displayName() {
        return holder.format("KeepBuildForEverAction.descriptor.displayName");
    }

    /**
     * Key {@code KeepBuildForEverAction.descriptor.displayName}: {@code Keep
     * Build Forever}.
     * 
     * @return
     *     {@code Keep Build Forever}
     */
    public static Localizable _KeepBuildForEverAction_descriptor_displayName() {
        return new Localizable(holder, "KeepBuildForEverAction.descriptor.displayName");
    }

    /**
     * Key {@code Promotion.PromotePermission.Description}: {@code This
     * permission allows user to use force promotion and re-execution of
     * promotion}.
     * 
     * @return
     *     {@code This permission allows user to use force promotion and
     *     re-execution of promotion}
     */
    public static String Promotion_PromotePermission_Description() {
        return holder.format("Promotion.PromotePermission.Description");
    }

    /**
     * Key {@code Promotion.PromotePermission.Description}: {@code This
     * permission allows user to use force promotion and re-execution of
     * promotion}.
     * 
     * @return
     *     {@code This permission allows user to use force promotion and
     *     re-execution of promotion}
     */
    public static Localizable _Promotion_PromotePermission_Description() {
        return new Localizable(holder, "Promotion.PromotePermission.Description");
    }

    /**
     * Key {@code JobPropertyImpl.LabelString.NoMatch}: {@code There's no
     * slave/cloud that matches this assignment}.
     * 
     * @return
     *     {@code There's no slave/cloud that matches this assignment}
     */
    public static String JobPropertyImpl_LabelString_NoMatch() {
        return holder.format("JobPropertyImpl.LabelString.NoMatch");
    }

    /**
     * Key {@code JobPropertyImpl.LabelString.NoMatch}: {@code There's no
     * slave/cloud that matches this assignment}.
     * 
     * @return
     *     {@code There's no slave/cloud that matches this assignment}
     */
    public static Localizable _JobPropertyImpl_LabelString_NoMatch() {
        return new Localizable(holder, "JobPropertyImpl.LabelString.NoMatch");
    }

    /**
     * Key {@code JobPropertyImpl.LabelString.InvalidBooleanExpression}:
     * {@code Invalid boolean expression: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid boolean expression: {0}}
     */
    public static String JobPropertyImpl_LabelString_InvalidBooleanExpression(Object arg0) {
        return holder.format("JobPropertyImpl.LabelString.InvalidBooleanExpression", arg0);
    }

    /**
     * Key {@code JobPropertyImpl.LabelString.InvalidBooleanExpression}:
     * {@code Invalid boolean expression: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid boolean expression: {0}}
     */
    public static Localizable _JobPropertyImpl_LabelString_InvalidBooleanExpression(Object arg0) {
        return new Localizable(holder, "JobPropertyImpl.LabelString.InvalidBooleanExpression", arg0);
    }

    /**
     * Key {@code Promotion.Permissions.Title}: {@code Promotion}.
     * 
     * @return
     *     {@code Promotion}
     */
    public static String Promotion_Permissions_Title() {
        return holder.format("Promotion.Permissions.Title");
    }

    /**
     * Key {@code Promotion.Permissions.Title}: {@code Promotion}.
     * 
     * @return
     *     {@code Promotion}
     */
    public static Localizable _Promotion_Permissions_Title() {
        return new Localizable(holder, "Promotion.Permissions.Title");
    }

    /**
     * Key {@code Promotion.RunnerImpl.Promoting}: {@code Promoting {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Promoting {0}}
     */
    public static String Promotion_RunnerImpl_Promoting(Object arg0) {
        return holder.format("Promotion.RunnerImpl.Promoting", arg0);
    }

    /**
     * Key {@code Promotion.RunnerImpl.Promoting}: {@code Promoting {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Promoting {0}}
     */
    public static Localizable _Promotion_RunnerImpl_Promoting(Object arg0) {
        return new Localizable(holder, "Promotion.RunnerImpl.Promoting", arg0);
    }

    /**
     * Key {@code KeepBuildForEverAction.console.notPromotion}: {@code This
     * build is not a promotion, how did we get here? Not keeping build.}.
     * 
     * @return
     *     {@code This build is not a promotion, how did we get here? Not keeping
     *     build.}
     */
    public static String KeepBuildForEverAction_console_notPromotion() {
        return holder.format("KeepBuildForEverAction.console.notPromotion");
    }

    /**
     * Key {@code KeepBuildForEverAction.console.notPromotion}: {@code This
     * build is not a promotion, how did we get here? Not keeping build.}.
     * 
     * @return
     *     {@code This build is not a promotion, how did we get here? Not keeping
     *     build.}
     */
    public static Localizable _KeepBuildForEverAction_console_notPromotion() {
        return new Localizable(holder, "KeepBuildForEverAction.console.notPromotion");
    }

}
