/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pom2config.handler.scm;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.plugins.git.GitSCM;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pom2config.DataSet;
import org.jenkinsci.plugins.pom2config.Pom2ConfigHandler;
import org.jenkinsci.plugins.pom2config.handler.scm.ScmGit;
import org.w3c.dom.Document;

@Extension
public class ScmHandler
extends Pom2ConfigHandler {
    public ScmHandler() {
        super(new ScmHandlerSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScmHandlerSpec
    extends Pom2ConfigHandler.Pom2ConfigHandlerSpec {
        private static final Logger LOG = Logger.getLogger(ScmHandler.class.getName());
        private final String scmLabel = "SCM URLs";
        private ScmGit gitHandler = null;

        @Override
        public String getName() {
            return "SCM";
        }

        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public boolean isActivatedInJob(AbstractProject<?, ?> project) {
            return !(project.getScm() instanceof NullSCM);
        }

        private boolean isGitAvailable() {
            try {
                new GitSCM("http:/test/foo.git");
                if (this.gitHandler == null) {
                    this.gitHandler = new ScmGit();
                }
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        protected List<String> getSCMPaths(AbstractProject<?, ?> project) {
            ArrayList<String> scmPaths = new ArrayList<String>();
            SCM scm = project.getScm();
            if (scm instanceof SubversionSCM) {
                SubversionSCM svn = (SubversionSCM)scm;
                for (SubversionSCM.ModuleLocation location : svn.getLocations()) {
                    scmPaths.add(location.remote);
                }
                return scmPaths;
            }
            if (this.isGitAvailable() && scm instanceof GitSCM) {
                return this.gitHandler.getGitPaths(project);
            }
            scmPaths.add("");
            return scmPaths;
        }

        protected String replaceScmUrl(AbstractProject<?, ?> project, String oldScmUrl, String newScmUrl) {
            String[] scmParts = newScmUrl.split(":");
            String scmUrl = "";
            String prefix = "";
            StringBuilder scmUrlBuilder = new StringBuilder();
            String message = "Unable to replace SCM URL";
            if (!"scm".equals(scmParts[0].trim())) {
                LOG.finest("No SCM address");
                return "Unable to replace SCM URL - No valid SCM address!";
            }
            if ("git".equals(scmParts[1]) && !this.isGitAvailable()) {
                return "Unable to replace Git URL - Git Plugin is not activated in the job!";
            }
            for (int i = 2; i < scmParts.length; ++i) {
                scmUrlBuilder.append(prefix);
                prefix = ":";
                scmUrlBuilder.append(scmParts[i].trim());
            }
            scmUrl = scmUrlBuilder.toString();
            if ("git".equals(scmParts[1])) {
                try {
                    message = this.gitHandler.replaceGitUrl(project, oldScmUrl, scmUrl);
                }
                catch (IOException e) {
                    LOG.finest("Unable to replace Git URL!" + e.getMessage());
                }
            } else if ("svn".equals(scmParts[1])) {
                try {
                    message = this.replaceSvnUrl(project, oldScmUrl, scmUrl);
                }
                catch (IOException e) {
                    LOG.finest("Unable to replace SVN URL!" + e.getMessage());
                }
            }
            return message;
        }

        private String replaceSvnUrl(AbstractProject<?, ?> project, String oldScmUrl, String newScmUrl) throws IOException {
            SubversionSCM newSCM;
            SCM scm = project.getScm();
            if (scm instanceof SubversionSCM) {
                SubversionSCM.ModuleLocation location2;
                SubversionSCM svnSCM = (SubversionSCM)scm;
                ArrayList<SubversionSCM.ModuleLocation> oldLocations = new ArrayList<SubversionSCM.ModuleLocation>(Arrays.asList(svnSCM.getProjectLocations(project)));
                for (SubversionSCM.ModuleLocation location2 : oldLocations) {
                    if (!location2.remote.trim().equals(oldScmUrl)) continue;
                    oldLocations.remove(location2);
                    break;
                }
                ArrayList<SubversionSCM.ModuleLocation> locationList = new ArrayList<SubversionSCM.ModuleLocation>();
                location2 = new SubversionSCM.ModuleLocation(newScmUrl, null);
                locationList.add(location2);
                locationList.addAll(oldLocations);
                newSCM = new SubversionSCM(locationList, svnSCM.getWorkspaceUpdater(), svnSCM.getBrowser(), svnSCM.getExcludedRegions(), svnSCM.getExcludedUsers(), svnSCM.getExcludedRevprop(), svnSCM.getExcludedCommitMessages(), svnSCM.getIncludedRegions(), svnSCM.isIgnoreDirPropChanges(), svnSCM.isFilterChangelog());
            } else {
                newSCM = new SubversionSCM(newScmUrl);
            }
            project.setScm((SCM)newSCM);
            project.save();
            return "SVN Url replaced";
        }

        @Override
        public List<DataSet> parsePom(AbstractProject<?, ?> project, Document doc) throws IOException {
            DataSet scmUrls = new DataSet("SCM URLs", this.isActivatedInJob(project), this.getSCMPaths(project), this.retrieveDetailsFromPom(doc, "//scm/connection/text()"));
            this.pomValues.add(scmUrls);
            return this.pomValues;
        }

        @Override
        public String setDetails(AbstractProject<?, ?> project, JSONObject formData) {
            String newScm = formData.getJSONObject("SCM URLs").getString("pomEntry").trim();
            String oldScm = formData.getJSONObject("SCM URLs").getString("configEntry").trim();
            if (!newScm.isEmpty()) {
                return this.replaceScmUrl(project, oldScm, newScm);
            }
            return "SCM Url not replaced!";
        }
    }
}

