/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pom2config;

import hudson.model.AbstractProject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pom2config.DataSet;
import org.jenkinsci.plugins.pom2config.Handler;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pom2ConfigHandler
implements Handler {
    private Pom2ConfigHandlerSpec spec;

    public Pom2ConfigHandler(Pom2ConfigHandlerSpec spec) {
        this.spec = spec;
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    @Override
    public List<DataSet> getPomValues() {
        return this.spec.getPomValues();
    }

    @Override
    public List<DataSet> parsePom(AbstractProject<?, ?> project, Document doc) throws IOException {
        this.spec.clearPomValues();
        return this.spec.parsePom(project, doc);
    }

    @Override
    public String setDetails(AbstractProject<?, ?> project, JSONObject formData) {
        return this.spec.setDetails(project, formData);
    }

    @Override
    public int compareTo(Handler handler) {
        return this.getName().compareToIgnoreCase(handler.getName());
    }

    @Override
    public boolean isLoaded() {
        return this.spec.isLoaded();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Pom2ConfigHandlerSpec {
        protected List<DataSet> pomValues = new ArrayList<DataSet>();

        public abstract String getName();

        public List<DataSet> getPomValues() {
            return this.pomValues;
        }

        public void clearPomValues() {
            this.pomValues.clear();
        }

        public abstract boolean isActivatedInJob(AbstractProject<?, ?> var1);

        public abstract boolean isLoaded();

        public abstract List<DataSet> parsePom(AbstractProject<?, ?> var1, Document var2) throws IOException;

        public abstract String setDetails(AbstractProject<?, ?> var1, JSONObject var2);

        protected String retrieveDetailsFromPom(Document doc, String path) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            StringBuilder builder = new StringBuilder();
            try {
                XPathExpression expr = xpath.compile(path);
                NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    builder.append(nodes.item(i).getNodeValue());
                    builder.append(" ");
                }
            }
            catch (XPathExpressionException ex) {
                // empty catch block
            }
            return builder.toString();
        }
    }
}

