/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pom2config;

import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.jenkinsci.plugins.pom2config.DataSet;
import org.jenkinsci.plugins.pom2config.Handler;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pom2Config
implements Action {
    private static final Logger LOG = Logger.getLogger(Pom2Config.class.getName());
    private final transient AbstractProject<?, ?> project;
    private List<Handler> pom2ConfigHandler = new ArrayList<Handler>();
    private List<String> messages = new ArrayList<String>();
    private List<DataSet> configDetails = new ArrayList<DataSet>();
    private List<Handler> notLoadedHandler = new ArrayList<Handler>();

    public Pom2Config(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public List<Handler> getHandler() {
        ExtensionList extensionList = Hudson.getInstance().getExtensionList(Handler.class);
        ArrayList<Handler> handlerList = new ArrayList<Handler>();
        for (Handler handler : extensionList) {
            if (handler.isLoaded()) {
                handlerList.add(handler);
                LOG.info("Loaded: " + handler.getClass());
                continue;
            }
            this.notLoadedHandler.add(handler);
            LOG.info("NOT Loaded: " + handler.getClass());
        }
        Collections.sort(handlerList);
        this.pom2ConfigHandler = handlerList;
        return this.pom2ConfigHandler;
    }

    public boolean isPomInWorkspace() {
        FilePath workspace = this.project.getWorkspace();
        if (this.project.getLastBuild() != null && this.project.getLastBuild().getWorkspace() != null) {
            workspace = this.project.getWorkspace();
        }
        if (workspace != null) {
            FilePath pomPath = this.project instanceof MavenModuleSet ? new FilePath(workspace, ((MavenModuleSet)this.project).getRootPOM(null)) : workspace.child("pom.xml");
            try {
                if (pomPath.exists()) {
                    return true;
                }
            }
            catch (IOException ex) {
                return false;
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return false;
    }

    public final void doGetPom(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String notRetrieved = "Unable to retrieve pom file.";
        String notParsed = "Unable to parse pom file.";
        Writer writer = rsp.getCompressedWriter((HttpServletRequest)req);
        this.pom2ConfigHandler.clear();
        this.notLoadedHandler.clear();
        this.getHandler();
        String pomAsString = "";
        try {
            pomAsString = this.retrievePom(req.getSubmittedForm().getJSONObject("fromWhere"));
        }
        catch (IOException ioe) {
            this.writeErrorMessage("Unable to retrieve pom file.", writer);
        }
        catch (InterruptedException ie) {
            this.writeErrorMessage("Unable to retrieve pom file.", writer);
        }
        catch (ServletException se) {
            this.writeErrorMessage("Unable to retrieve pom file.", writer);
        }
        if (!pomAsString.isEmpty()) {
            try {
                this.parsePom(pomAsString);
            }
            catch (ParserConfigurationException e) {
                this.writeErrorMessage("Unable to parse pom file.", writer);
            }
            catch (SAXException e) {
                this.writeErrorMessage("Unable to parse pom file.", writer);
            }
            catch (IOException e) {
                this.writeErrorMessage("Unable to parse pom file.", writer);
            }
            rsp.sendRedirect("chooseDetails");
        } else {
            this.writeErrorMessage("Unable to retrieve pom file.", writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeErrorMessage(String message, Writer writer) throws IOException {
        try {
            writer.append(message + "\n");
        }
        finally {
            writer.close();
        }
    }

    private String retrievePom(JSONObject formData) throws ServletException, IOException, InterruptedException {
        String pomAsString = "";
        String fromWhere = formData.getString("value");
        if ("useExisting".equals(fromWhere)) {
            FilePath pomPath;
            FilePath workspace = this.project.getWorkspace();
            if (this.project.getLastBuild() != null && this.project.getLastBuild().getWorkspace() != null) {
                workspace = this.project.getLastBuild().getWorkspace();
            }
            if (workspace != null && (pomPath = workspace.child("pom.xml")).exists()) {
                pomAsString = pomPath.readToString();
            }
        } else if ("fromUrl".equals(fromWhere)) {
            String inputLine;
            URL pomURL = new URL(formData.getString("location"));
            BufferedReader in = new BufferedReader(new InputStreamReader(pomURL.openStream()));
            StringBuilder builder = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                builder.append(inputLine);
            }
            in.close();
            pomAsString = builder.toString();
        } else {
            FileItem fileItem = Stapler.getCurrentRequest().getFileItem(formData.getString("file"));
            pomAsString = fileItem.getString();
        }
        return pomAsString;
    }

    private void parsePom(String xml) throws ParserConfigurationException, SAXException, IOException {
        this.configDetails.clear();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document doc = db.parse(is);
        for (Handler handler : this.pom2ConfigHandler) {
            handler.parsePom(this.project, doc);
        }
    }

    public final void doSetDetails(StaplerRequest req, StaplerResponse rsp) throws IOException, URISyntaxException, ServletException {
        JSONObject formData = null;
        formData = req.getSubmittedForm();
        LOG.finest(formData.toString(2));
        for (Handler handler : this.pom2ConfigHandler) {
            List<DataSet> values = handler.getPomValues();
            for (DataSet dataSet : values) {
                if (!formData.containsKey((Object)dataSet.getName())) continue;
                this.messages.add(handler.setDetails(this.project, formData));
            }
        }
        rsp.forward((Object)this, "showOutcome", req);
    }

    public String getDisplayName() {
        return "Pom2Config";
    }

    public String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/pom2config/icons/find-replace-32x32.png";
    }

    public String getUrlName() {
        return "pom2config";
    }

    public List<Handler> getNotLoadedHandler() {
        return this.notLoadedHandler;
    }

    public List<Handler> getPom2ConfigHandler() {
        return this.pom2ConfigHandler;
    }

    public List<String> getMessages() {
        return this.messages;
    }
}

