/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.SeriesFactory;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PropertiesSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(PropertiesSeries.class.getName());

    @DataBoundConstructor
    public PropertiesSeries(String file, String label) {
        super(file, label, "properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlotPoint> loadSeries(FilePath workspaceRootDir, int buildNumber, PrintStream logger) {
        ArrayList<PlotPoint> arrayList;
        String url;
        String yvalue;
        Object[] seriesFiles;
        InputStream in;
        block8: {
            in = null;
            try {
                seriesFiles = workspaceRootDir.list(this.getFile());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception trying to retrieve series files", e);
                return null;
            }
            if (ArrayUtils.isEmpty((Object[])seriesFiles)) {
                logger.println("No plot data file found: " + this.getFile());
                return null;
            }
            in = seriesFiles[0].read();
            logger.println("Saving plot series data from: " + seriesFiles[0]);
            Properties properties = new Properties();
            properties.load(in);
            yvalue = properties.getProperty("YVALUE");
            url = properties.getProperty("URL", "");
            if (yvalue != null && url != null) break block8;
            logger.println("Not creating point with null values: y=" + yvalue + " label=" + this.getLabel() + " url=" + url);
            List<PlotPoint> list = null;
            IOUtils.closeQuietly((InputStream)in);
            return list;
        }
        try {
            ArrayList<PlotPoint> series = new ArrayList<PlotPoint>();
            series.add(new PlotPoint(yvalue, url, this.getLabel()));
            arrayList = series;
        }
        catch (Exception e) {
            List<PlotPoint> list;
            try {
                LOGGER.log(Level.SEVERE, "Exception reading plot series data from " + seriesFiles[0], e);
                list = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return list;
        }
        IOUtils.closeQuietly((InputStream)in);
        return arrayList;
    }

    @Override
    public Descriptor<Series> getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Series> {
        public String getDisplayName() {
            return Messages.Plot_PropertiesSeries();
        }

        public Series newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return SeriesFactory.createSeries(formData, req);
        }
    }
}

