/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotPublisher;
import hudson.plugins.plot.SeriesFactory;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class PlotDescriptor
extends BuildStepDescriptor<Publisher> {
    public PlotDescriptor() {
        super(PlotPublisher.class);
    }

    public String getDisplayName() {
        return Messages.Plot_Publisher_DisplayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return AbstractProject.class.isAssignableFrom(jobType) && !MatrixProject.class.isAssignableFrom(jobType);
    }

    public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        PlotPublisher publisher = new PlotPublisher();
        for (Object data : SeriesFactory.getArray(formData.get("plots"))) {
            publisher.addPlot(PlotDescriptor.bindPlot((JSONObject)data, req));
        }
        return publisher;
    }

    private static Plot bindPlot(JSONObject data, StaplerRequest req) {
        Plot p = (Plot)req.bindJSON(Plot.class, data);
        p.series = SeriesFactory.createSeriesList(data.get("series"), req);
        return p;
    }

    public FormValidation doCheckSeriesFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
        if (project == null || project.getRootDir() == null) {
            return FormValidation.ok();
        }
        return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
    }
}

