/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.SeriesFactory;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(XMLSeries.class.getName());
    private static final transient Level defaultLogLevel = Level.INFO;
    private static final transient Map<String, QName> qnameMap;
    private String xpathString;
    private String url;
    private String nodeTypeString;
    private transient QName nodeType;

    @DataBoundConstructor
    public XMLSeries(String file, String xpath, String nodeType, String url) {
        super(file, "", "xml");
        this.xpathString = xpath;
        this.nodeTypeString = nodeType;
        this.nodeType = qnameMap.get(nodeType);
        this.url = url;
    }

    private Object readResolve() {
        this.nodeType = qnameMap.get(this.nodeTypeString);
        return this;
    }

    public String getXpath() {
        return this.xpathString;
    }

    public String getNodeType() {
        return this.nodeTypeString;
    }

    public String getUrl() {
        return this.url;
    }

    private List<PlotPoint> mapNodeNameAsLabelTextContentAsValueStrategy(NodeList nodeList, int buildNumber) {
        ArrayList<PlotPoint> retval = new ArrayList<PlotPoint>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.addNodeToList(retval, nodeList.item(i), buildNumber);
        }
        return retval;
    }

    private List<PlotPoint> coalesceTextnodesAsLabelsStrategy(NodeList nodeList, int buildNumber) {
        HashMap parentNodeMap = new HashMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!parentNodeMap.containsKey(node.getParentNode())) {
                parentNodeMap.put(node.getParentNode(), new ArrayList());
            }
            ((List)parentNodeMap.get(node.getParentNode())).add(node);
        }
        ArrayList<PlotPoint> retval = new ArrayList<PlotPoint>();
        ArrayDeque parents = new ArrayDeque(parentNodeMap.keySet());
        while (!parents.isEmpty()) {
            Node parent = (Node)parents.poll();
            Double value = null;
            String label = null;
            for (Node child : (List)parentNodeMap.get(parent)) {
                if (null == child.getTextContent() || child.getTextContent().trim().isEmpty()) {
                    NamedNodeMap attrmap = child.getAttributes();
                    ArrayList<Node> attrs = new ArrayList<Node>();
                    for (int i = 0; i < attrmap.getLength(); ++i) {
                        attrs.add(attrmap.item(i));
                    }
                    parentNodeMap.put(child, attrs);
                    parents.add(child);
                    continue;
                }
                if (new Scanner(child.getTextContent().trim()).hasNextDouble()) {
                    value = new Scanner(child.getTextContent().trim()).nextDouble();
                    continue;
                }
                label = child.getTextContent().trim();
            }
            if (label == null || value == null) continue;
            this.addValueToList(retval, label, String.valueOf(value), buildNumber);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PlotPoint> loadSeries(FilePath workspaceRootDir, int buildNumber, PrintStream logger) {
        InputStream in = null;
        try {
            InputSource inputSource;
            Object[] seriesFiles;
            ArrayList<PlotPoint> ret = new ArrayList<PlotPoint>();
            try {
                seriesFiles = workspaceRootDir.list(this.getFile());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception trying to retrieve series files", e);
                List<PlotPoint> list = null;
                IOUtils.closeQuietly(in);
                return list;
            }
            if (ArrayUtils.isEmpty((Object[])seriesFiles)) {
                LOGGER.info("No plot data file found: " + this.getFile());
                List<PlotPoint> e = null;
                IOUtils.closeQuietly((InputStream)in);
                return e;
            }
            try {
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Loading plot series data from: " + this.getFile());
                }
                in = seriesFiles[0].read();
                inputSource = new InputSource(in);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception reading plot series data from " + seriesFiles[0], e);
                List<PlotPoint> list = null;
                IOUtils.closeQuietly((InputStream)in);
                return list;
            }
            if (LOGGER.isLoggable(defaultLogLevel)) {
                LOGGER.log(defaultLogLevel, "NodeType " + this.nodeTypeString + " : " + this.nodeType);
            }
            if (LOGGER.isLoggable(defaultLogLevel)) {
                LOGGER.log(defaultLogLevel, "Loaded XML Plot file: " + this.getFile());
            }
            XPath xpath = XPathFactory.newInstance().newXPath();
            Object xmlObject = xpath.evaluate(this.xpathString, inputSource, this.nodeType);
            if (this.nodeType.equals(XPathConstants.NODESET)) {
                NodeList nl = (NodeList)xmlObject;
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Number of nodes: " + nl.getLength());
                }
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    if (new Scanner(node.getTextContent().trim()).hasNextDouble()) continue;
                    List<PlotPoint> list = this.coalesceTextnodesAsLabelsStrategy(nl, buildNumber);
                    IOUtils.closeQuietly((InputStream)in);
                    return list;
                }
                List<PlotPoint> i = this.mapNodeNameAsLabelTextContentAsValueStrategy(nl, buildNumber);
                IOUtils.closeQuietly((InputStream)in);
                return i;
            }
            if (this.nodeType.equals(XPathConstants.NODE)) {
                this.addNodeToList(ret, (Node)xmlObject, buildNumber);
            } else if (xmlObject instanceof NodeList) {
                NodeList nl = (NodeList)xmlObject;
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Number of nodes: " + nl.getLength());
                }
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    if (n == null || n.getLocalName() == null || n.getTextContent() == null) continue;
                    this.addValueToList(ret, this.label, xmlObject, buildNumber);
                }
            } else {
                this.addValueToList(ret, this.label, xmlObject, buildNumber);
            }
            ArrayList<PlotPoint> arrayList = ret;
            IOUtils.closeQuietly((InputStream)in);
            return arrayList;
        }
        catch (XPathExpressionException e) {
            LOGGER.log(Level.SEVERE, "XPathExpressionException for XPath '" + this.getXpath() + "'", e);
            return null;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private void addNodeToList(List<PlotPoint> ret, Node n, int buildNumber) {
        NamedNodeMap nodeMap = n.getAttributes();
        if (null != nodeMap && null != nodeMap.getNamedItem("name")) {
            this.addValueToList(ret, nodeMap.getNamedItem("name").getTextContent().trim(), n, buildNumber);
        } else {
            this.addValueToList(ret, n.getLocalName().trim(), n, buildNumber);
        }
    }

    private String nodeToString(Object obj) {
        Scanner scanner;
        String ret = null;
        if (this.nodeType == XPathConstants.BOOLEAN) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if (this.nodeType == XPathConstants.NUMBER) {
            return ((Double)obj).toString().trim();
        }
        if (this.nodeType == XPathConstants.NODE || this.nodeType == XPathConstants.NODESET) {
            if (obj instanceof String) {
                ret = ((String)obj).trim();
            } else {
                if (null == obj) {
                    return null;
                }
                Node node = (Node)obj;
                NamedNodeMap nodeMap = node.getAttributes();
                if (null != nodeMap && null != nodeMap.getNamedItem("time")) {
                    ret = nodeMap.getNamedItem("time").getTextContent();
                }
                if (null == ret) {
                    ret = node.getTextContent().trim();
                }
            }
        }
        if (this.nodeType == XPathConstants.STRING) {
            ret = ((String)obj).trim();
        }
        if ((scanner = new Scanner(ret)).hasNextDouble()) {
            return String.valueOf(scanner.nextDouble());
        }
        return null;
    }

    private void addValueToList(List<PlotPoint> list, String label, Object nodeValue, int buildNumber) {
        String value = this.nodeToString(nodeValue);
        if (value != null) {
            if (LOGGER.isLoggable(defaultLogLevel)) {
                LOGGER.log(defaultLogLevel, "Adding node: " + label + " value: " + value);
            }
            list.add(new PlotPoint(value, this.getUrl(this.url, label, 0, buildNumber), label));
        } else if (LOGGER.isLoggable(defaultLogLevel)) {
            LOGGER.log(defaultLogLevel, "Unable to add node: " + label + " value: " + nodeValue);
        }
    }

    @Override
    public Descriptor<Series> getDescriptor() {
        return new DescriptorImpl();
    }

    static {
        HashMap<String, QName> tempMap = new HashMap<String, QName>();
        tempMap.put("BOOLEAN", XPathConstants.BOOLEAN);
        tempMap.put("NODE", XPathConstants.NODE);
        tempMap.put("NODESET", XPathConstants.NODESET);
        tempMap.put("NUMBER", XPathConstants.NUMBER);
        tempMap.put("STRING", XPathConstants.STRING);
        qnameMap = Collections.unmodifiableMap(tempMap);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Series> {
        public String getDisplayName() {
            return Messages.Plot_XmlSeries();
        }

        public Series newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return SeriesFactory.createSeries(formData, req);
        }
    }
}

