/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.FilePath;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.PropertiesSeries;
import java.io.PrintStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Series {
    private static final transient Pattern PAT_NAME = Pattern.compile("%name%");
    private static final transient Pattern PAT_INDEX = Pattern.compile("%index%");
    private static final Pattern PAT_BUILD_NUMBER = Pattern.compile("%build%");
    protected String file;
    protected String label;
    protected String fileType;

    protected Series(String file, String label, String fileType) {
        this.file = file;
        if (label == null) {
            label = Messages.Plot_Missing();
        }
        this.label = label;
        this.fileType = fileType;
    }

    public String getFile() {
        return this.file;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFileType() {
        return this.fileType;
    }

    public abstract List<PlotPoint> loadSeries(FilePath var1, int var2, PrintStream var3);

    private Object readResolve() {
        return this.fileType == null ? new PropertiesSeries(this.file, this.label) : this;
    }

    protected String getUrl(String baseUrl, String label, int index, int buildNumber) {
        String resultUrl = baseUrl;
        if (resultUrl != null) {
            Matcher buildNumberMatcher;
            Matcher indexMatcher;
            Matcher nameMatcher;
            if (label == null) {
                label = "";
            }
            if ((nameMatcher = PAT_NAME.matcher(resultUrl)).find()) {
                resultUrl = nameMatcher.replaceAll(label);
            }
            if ((indexMatcher = PAT_INDEX.matcher(resultUrl)).find()) {
                resultUrl = indexMatcher.replaceAll(String.valueOf(index));
            }
            if ((buildNumberMatcher = PAT_BUILD_NUMBER.matcher(resultUrl)).find()) {
                resultUrl = buildNumberMatcher.replaceAll(String.valueOf(buildNumber));
            }
        }
        return resultUrl;
    }
}

