/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.FilePath;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(XMLSeries.class.getName());
    private static final transient Level defaultLogLevel = Level.INFO;
    private static final transient Pattern PAT_NAME = Pattern.compile("%name%");
    private static final transient Pattern PAT_INDEX = Pattern.compile("%index%");
    private static final transient Map<String, QName> qnameMap;
    private String xpathString;
    private String url;
    private String nodeTypeString;
    private transient QName nodeType;

    @DataBoundConstructor
    public XMLSeries(String file, String xpath, String nodeType, String url) {
        super(file, "", "xml");
        this.xpathString = xpath;
        this.nodeTypeString = nodeType;
        this.nodeType = qnameMap.get(nodeType);
        this.url = url;
    }

    private Object readResolve() {
        this.nodeType = qnameMap.get(this.nodeTypeString);
        return this;
    }

    public String getXpath() {
        return this.xpathString;
    }

    public String getNodeType() {
        return this.nodeTypeString;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlotPoint> loadSeries(FilePath workspaceRootDir, PrintStream logger) {
        block34: {
            ArrayList<PlotPoint> arrayList;
            InputStream in = null;
            InputSource inputSource = null;
            try {
                NodeList nl;
                ArrayList<PlotPoint> ret = new ArrayList<PlotPoint>();
                Object[] seriesFiles = null;
                try {
                    seriesFiles = workspaceRootDir.list(this.getFile());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception trying to retrieve series files", e);
                    List<PlotPoint> list = null;
                    IOUtils.closeQuietly(in);
                    return list;
                }
                if (ArrayUtils.isEmpty((Object[])seriesFiles)) {
                    LOGGER.info("No plot data file found: " + this.getFile());
                    List<PlotPoint> e = null;
                    IOUtils.closeQuietly((InputStream)in);
                    return e;
                }
                try {
                    if (LOGGER.isLoggable(defaultLogLevel)) {
                        LOGGER.log(defaultLogLevel, "Loading plot series data from: " + this.getFile());
                    }
                    in = seriesFiles[0].read();
                    inputSource = new InputSource(in);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception reading plot series data from " + seriesFiles[0], e);
                    List<PlotPoint> list = null;
                    IOUtils.closeQuietly((InputStream)in);
                    return list;
                }
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "NodeType " + this.nodeTypeString + " : " + this.nodeType);
                }
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Loaded XML Plot file: " + this.getFile());
                }
                XPath xpath = XPathFactory.newInstance().newXPath();
                Object xmlObject = xpath.evaluate(this.xpathString, inputSource, this.nodeType);
                if (this.nodeType.equals(XPathConstants.NODESET)) {
                    nl = (NodeList)xmlObject;
                    if (LOGGER.isLoggable(defaultLogLevel)) {
                        LOGGER.log(defaultLogLevel, "Number of nodes: " + nl.getLength());
                    }
                    HashMap<Node, LinkedList<Node>> parentNodeMap = new HashMap<Node, LinkedList<Node>>();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node node = nl.item(i);
                        Node parent = node.getParentNode();
                        LinkedList<Node> nodeList = (LinkedList<Node>)parentNodeMap.get(parent);
                        Node obj = nl.item(i);
                        Node obj2 = node.getFirstChild();
                        if (node.getFirstChild() == null) continue;
                        if (nodeList == null) {
                            nodeList = new LinkedList<Node>();
                            parentNodeMap.put(parent, nodeList);
                        }
                        nodeList.add(node);
                    }
                    int numParents = parentNodeMap.size();
                    int numNodes = nl.getLength();
                    if (parentNodeMap.size() != 0 && parentNodeMap.size() < nl.getLength()) {
                        Set entries = parentNodeMap.entrySet();
                        for (Map.Entry entry : entries) {
                            String name = null;
                            String value = null;
                            List nodeList = (List)entry.getValue();
                            for (Node node : nodeList) {
                                try {
                                    Double.parseDouble(node.getTextContent());
                                    value = node.getTextContent().trim();
                                }
                                catch (NumberFormatException nfe) {
                                    LOGGER.log(Level.SEVERE, "Exception converting to number", nfe);
                                    name = node.getTextContent().trim();
                                }
                            }
                            this.addValueToList(ret, name, value);
                        }
                    } else {
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Node n = nl.item(i);
                            if (n == null || n.getLocalName() == null || n.getTextContent() == null) continue;
                            this.addNodeToList(ret, n);
                        }
                    }
                } else if (this.nodeType.equals(XPathConstants.NODE)) {
                    this.addNodeToList(ret, (Node)xmlObject);
                } else if (xmlObject instanceof NodeList) {
                    nl = (NodeList)xmlObject;
                    if (LOGGER.isLoggable(defaultLogLevel)) {
                        LOGGER.log(defaultLogLevel, "Number of nodes: " + nl.getLength());
                    }
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        if (n == null || n.getLocalName() == null || n.getTextContent() == null) continue;
                        this.addValueToList(ret, this.label, xmlObject);
                    }
                } else {
                    this.addValueToList(ret, this.label, xmlObject);
                }
                arrayList = ret;
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (XPathExpressionException e) {
                LOGGER.log(Level.SEVERE, "XPathExpressionException for XPath '" + this.getXpath() + "'", e);
                break block34;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            return arrayList;
        }
        return null;
    }

    private void addNodeToList(List<PlotPoint> ret, Node n) {
        NamedNodeMap nodeMap = n.getAttributes();
        if (null != nodeMap && null != nodeMap.getNamedItem("name")) {
            this.addValueToList(ret, nodeMap.getNamedItem("name").getTextContent().trim(), n);
        } else {
            this.addValueToList(ret, n.getLocalName().trim(), n);
        }
    }

    private String getUrl(String label, int index) {
        Matcher indexMatcher;
        Matcher nameMatcher = PAT_NAME.matcher(label);
        if (nameMatcher.find()) {
            this.url = nameMatcher.replaceAll(label);
        }
        if ((indexMatcher = PAT_INDEX.matcher(label)).find()) {
            this.url = indexMatcher.replaceAll(label);
        }
        return this.url;
    }

    private String nodeToString(Object obj) {
        String ret = null;
        if (this.nodeType == XPathConstants.BOOLEAN) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if (this.nodeType == XPathConstants.NUMBER) {
            return ((Double)obj).toString().trim();
        }
        if (this.nodeType == XPathConstants.NODE || this.nodeType == XPathConstants.NODESET) {
            if (obj instanceof String) {
                ret = ((String)obj).trim();
            } else {
                if (null == obj) {
                    return null;
                }
                Node node = (Node)obj;
                NamedNodeMap nodeMap = node.getAttributes();
                if (null != nodeMap && null != nodeMap.getNamedItem("time")) {
                    ret = nodeMap.getNamedItem("time").getTextContent();
                }
                if (null == ret) {
                    ret = node.getTextContent().trim();
                }
            }
        }
        if (this.nodeType == XPathConstants.STRING) {
            ret = ((String)obj).trim();
        }
        if (ret != null) {
            ret = this.removeCommas(ret);
            try {
                Double.parseDouble(ret);
            }
            catch (NumberFormatException ignore) {
                LOGGER.log(Level.SEVERE, "Exception converting to number", ignore);
            }
            return ret;
        }
        return null;
    }

    private String removeCommas(String ret) {
        int length = ret.length();
        StringBuilder r = new StringBuilder(length);
        r.setLength(length);
        int current = 0;
        for (int i = 0; i < ret.length(); ++i) {
            char cur = ret.charAt(i);
            if (cur != ',') {
                r.setCharAt(current++, cur);
                continue;
            }
            r.setLength(--length);
        }
        ret = r.toString().trim();
        return ret;
    }

    private void addValueToList(List<PlotPoint> list, String label, Object nodeValue) {
        String value = this.nodeToString(nodeValue);
        if (value != null) {
            if (LOGGER.isLoggable(defaultLogLevel)) {
                LOGGER.log(defaultLogLevel, "Adding node: " + label + " value: " + value);
            }
            list.add(new PlotPoint(value, this.getUrl(label, 0), label));
        } else if (LOGGER.isLoggable(defaultLogLevel)) {
            LOGGER.log(defaultLogLevel, "Unable to add node: " + label + " value: " + nodeValue);
        }
    }

    static {
        HashMap<String, QName> tempMap = new HashMap<String, QName>();
        tempMap.put("BOOLEAN", XPathConstants.BOOLEAN);
        tempMap.put("NODE", XPathConstants.NODE);
        tempMap.put("NODESET", XPathConstants.NODESET);
        tempMap.put("NUMBER", XPathConstants.NUMBER);
        tempMap.put("STRING", XPathConstants.STRING);
        qnameMap = Collections.unmodifiableMap(tempMap);
    }
}

