/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotPublisher;
import hudson.plugins.plot.PlotReport;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotAction
implements Action,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(PlotAction.class.getName());
    private final AbstractProject<?, ?> project;
    private final PlotPublisher publisher;

    public PlotAction(AbstractProject<?, ?> project, PlotPublisher publisher) {
        this.project = project;
        this.publisher = publisher;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getDisplayName() {
        return Messages.Plot_Action_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return Messages.Plot_UrlName();
    }

    public boolean hasPlots() throws IOException {
        return CollectionUtils.isNotEmpty(this.publisher.getPlots());
    }

    public List<String> getOriginalGroups() {
        return this.publisher.getOriginalGroups();
    }

    public String getUrlGroup(String originalGroup) {
        return this.publisher.originalGroupToUrlEncodedGroup(originalGroup);
    }

    public PlotReport getDynamic(String group, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return new PlotReport(this.project, this.publisher.urlGroupToOriginalGroup(this.getUrlGroup(group)), this.publisher.getPlots(this.getUrlGroup(group)));
    }

    public Object getTarget() {
        List<String> groups = this.getOriginalGroups();
        if (groups != null && groups.size() == 1) {
            return new PlotReport(this.project, groups.get(0), this.publisher.getPlots(this.getUrlGroup(groups.get(0))));
        }
        return this;
    }
}

