/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import hudson.FilePath;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(CSVSeries.class.getName());
    private static final transient Level defaultLogLevel = Level.FINEST;
    private static final transient Pattern PAT_COMMA = Pattern.compile(",");
    private Set<String> strExclusionSet;
    private Set<Integer> colExclusionSet;
    private InclusionFlag inclusionFlag = InclusionFlag.OFF;
    private String exclusionValues;
    private String url;
    private boolean displayTableFlag;

    @DataBoundConstructor
    public CSVSeries(String file, String url, String inclusionFlag, String exclusionValues, boolean displayTableFlag) {
        super(file, "", "csv");
        this.url = url;
        if (exclusionValues == null) {
            this.inclusionFlag = InclusionFlag.OFF;
            return;
        }
        this.inclusionFlag = InclusionFlag.valueOf(inclusionFlag);
        this.exclusionValues = exclusionValues;
        this.displayTableFlag = displayTableFlag;
        this.loadExclusionSet();
    }

    public String getInclusionFlag() {
        return ObjectUtils.toString((Object)((Object)this.inclusionFlag));
    }

    public String getExclusionValues() {
        return this.exclusionValues;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getDisplayTableFlag() {
        return this.displayTableFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PlotPoint> loadSeries(FilePath workspaceRootDir, int buildNumber, PrintStream logger) {
        ArrayList<PlotPoint> arrayList;
        InputStreamReader inputReader;
        InputStream in;
        CSVReader reader;
        block38: {
            block39: {
                List<PlotPoint> e2;
                block36: {
                    block37: {
                        reader = null;
                        in = null;
                        inputReader = null;
                        try {
                            String[] nextLine;
                            ArrayList<PlotPoint> ret = new ArrayList<PlotPoint>();
                            Object[] seriesFiles = null;
                            try {
                                seriesFiles = workspaceRootDir.list(this.getFile());
                            }
                            catch (Exception e2) {
                                LOGGER.log(Level.SEVERE, "Exception trying to retrieve series files", e2);
                                List<PlotPoint> list = null;
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException ignore) {
                                        // empty catch block
                                    }
                                }
                                IOUtils.closeQuietly(inputReader);
                                IOUtils.closeQuietly(in);
                                return list;
                            }
                            if (ArrayUtils.isEmpty((Object[])seriesFiles)) {
                                LOGGER.info("No plot data file found: " + workspaceRootDir.getName() + " " + this.getFile());
                                e2 = null;
                                if (reader == null) break block36;
                                break block37;
                            }
                            try {
                                if (LOGGER.isLoggable(defaultLogLevel)) {
                                    LOGGER.log(defaultLogLevel, "Loading plot series data from: " + this.getFile());
                                }
                                in = seriesFiles[0].read();
                            }
                            catch (Exception e3) {
                                LOGGER.log(Level.SEVERE, "Exception reading plot series data from " + seriesFiles[0], e3);
                                List<PlotPoint> ignore = null;
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException ignore2) {
                                        // empty catch block
                                    }
                                }
                                IOUtils.closeQuietly((Reader)inputReader);
                                IOUtils.closeQuietly((InputStream)in);
                                return ignore;
                            }
                            if (LOGGER.isLoggable(defaultLogLevel)) {
                                LOGGER.log(defaultLogLevel, "Loaded CSV Plot file: " + this.getFile());
                            }
                            inputReader = new InputStreamReader(in);
                            reader = new CSVReader((Reader)inputReader);
                            String[] headerLine = reader.readNext();
                            int lineNum = 0;
                            while ((nextLine = reader.readNext()) != null) {
                                if (nextLine.length == 1 && nextLine[0].length() == 0) continue;
                                for (int index = 0; index < nextLine.length; ++index) {
                                    String yvalue;
                                    String label = null;
                                    if (index > nextLine.length || (yvalue = nextLine[index]).trim().length() == 0) continue;
                                    if (index < headerLine.length) {
                                        label = headerLine[index];
                                    }
                                    if (label == null || label.length() <= 0) {
                                        label = "" + index;
                                    }
                                    if (!this.excludePoint(label, index)) {
                                        PlotPoint point = new PlotPoint(yvalue, this.getUrl(this.url, label, index, buildNumber), label);
                                        if (LOGGER.isLoggable(defaultLogLevel)) {
                                            LOGGER.log(defaultLogLevel, "CSV Point: [" + index + ":" + lineNum + "]" + point);
                                        }
                                        ret.add(point);
                                        continue;
                                    }
                                    if (!LOGGER.isLoggable(defaultLogLevel)) continue;
                                    LOGGER.log(defaultLogLevel, "excluded CSV Column: " + index + " : " + label);
                                }
                                ++lineNum;
                            }
                            arrayList = ret;
                            if (reader == null) break block38;
                            break block39;
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.SEVERE, "Exception loading series", ioe);
                            return null;
                        }
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly(inputReader);
                IOUtils.closeQuietly((InputStream)in);
                return e2;
            }
            try {
                reader.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        IOUtils.closeQuietly((Reader)inputReader);
        IOUtils.closeQuietly((InputStream)in);
        return arrayList;
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
            IOUtils.closeQuietly(inputReader);
            IOUtils.closeQuietly(in);
        }
    }

    private boolean excludePoint(String label, int index) {
        if (this.inclusionFlag == null || this.inclusionFlag == InclusionFlag.OFF) {
            return false;
        }
        boolean retVal = false;
        switch (this.inclusionFlag) {
            case INCLUDE_BY_STRING: {
                retVal = !this.strExclusionSet.contains(label);
                break;
            }
            case EXCLUDE_BY_STRING: {
                retVal = this.strExclusionSet.contains(label);
                break;
            }
            case INCLUDE_BY_COLUMN: {
                retVal = !this.colExclusionSet.contains(index);
                break;
            }
            case EXCLUDE_BY_COLUMN: {
                retVal = this.colExclusionSet.contains(index);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest((retVal ? "excluded" : "included") + " CSV Column: " + index + " : " + label);
        }
        return retVal;
    }

    private void loadExclusionSet() {
        if (this.inclusionFlag == InclusionFlag.OFF) {
            return;
        }
        if (this.exclusionValues == null) {
            this.inclusionFlag = InclusionFlag.OFF;
            return;
        }
        switch (this.inclusionFlag) {
            case INCLUDE_BY_STRING: 
            case EXCLUDE_BY_STRING: {
                this.strExclusionSet = new HashSet<String>();
                break;
            }
            case INCLUDE_BY_COLUMN: 
            case EXCLUDE_BY_COLUMN: {
                this.colExclusionSet = new HashSet<Integer>();
            }
        }
        block10: for (String str : PAT_COMMA.split(this.exclusionValues)) {
            if (str == null || str.length() <= 0) continue;
            switch (this.inclusionFlag) {
                case INCLUDE_BY_STRING: 
                case EXCLUDE_BY_STRING: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest((Object)((Object)this.inclusionFlag) + " CSV Column: " + str);
                    }
                    this.strExclusionSet.add(str);
                    continue block10;
                }
                case INCLUDE_BY_COLUMN: 
                case EXCLUDE_BY_COLUMN: {
                    try {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest((Object)((Object)this.inclusionFlag) + " CSV Column: " + str);
                        }
                        this.colExclusionSet.add(Integer.valueOf(str));
                        continue block10;
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InclusionFlag {
        OFF,
        INCLUDE_BY_STRING,
        EXCLUDE_BY_STRING,
        INCLUDE_BY_COLUMN,
        EXCLUDE_BY_COLUMN;

    }
}

